/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts;

import dmr.DragonMounts.DMR;
import dmr.DragonMounts.client.gui.DragonInventoryScreen;
import dmr.DragonMounts.client.model.DragonEggModelLoader;
import dmr.DragonMounts.registry.ModItems;
import dmr.DragonMounts.registry.ModMenus;
import dmr.DragonMounts.server.items.DragonSpawnEgg;
import dmr.DragonMounts.types.ResourcePackLoader;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientRegistry {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void setupClient(FMLClientSetupEvent event) {
        ResourcePackLoader.addReloadListener(event);
        ModContainer modContainer = ModLoadingContext.get().getActiveContainer();
        modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(mc, parent) -> new ConfigurationScreen(modContainer, parent)));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerMenus(RegisterMenuScreensEvent e) {
        e.register(ModMenus.DRAGON_MENU.get(), DragonInventoryScreen::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerGeometryLoaders(ModelEvent.RegisterGeometryLoaders e) {
        e.register(DMR.id("dragon_egg"), (IGeometryLoader)DragonEggModelLoader.INSTANCE);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerColorHandlers(RegisterColorHandlersEvent.Item e) {
        e.register((stack, layer) -> FastColor.ARGB32.opaque((int)DragonSpawnEgg.getColor(stack, layer)), new ItemLike[]{(ItemLike)ModItems.DRAGON_SPAWN_EGG.get()});
    }
}

