/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.CommandDispatcher;
import dmr.DragonMounts.config.ClientConfig;
import dmr.DragonMounts.config.ServerConfig;
import dmr.DragonMounts.network.packets.PacketRegistry;
import dmr.DragonMounts.registry.ModActivityTypes;
import dmr.DragonMounts.registry.ModBlockEntities;
import dmr.DragonMounts.registry.ModBlocks;
import dmr.DragonMounts.registry.ModCapabilities;
import dmr.DragonMounts.registry.ModComponents;
import dmr.DragonMounts.registry.ModCreativeTabs;
import dmr.DragonMounts.registry.ModCriterionTriggers;
import dmr.DragonMounts.registry.ModCustomRecipes;
import dmr.DragonMounts.registry.ModEntities;
import dmr.DragonMounts.registry.ModItems;
import dmr.DragonMounts.registry.ModMemoryModuleTypes;
import dmr.DragonMounts.registry.ModMenus;
import dmr.DragonMounts.registry.ModParticles;
import dmr.DragonMounts.registry.ModSensors;
import dmr.DragonMounts.registry.ModSounds;
import dmr.DragonMounts.server.commands.DMRCommand;
import dmr.DragonMounts.server.events.LootTableInject;
import dmr.DragonMounts.types.DataPackHandler;
import dmr.DragonMounts.types.abilities.types.Ability;
import dmr.DragonMounts.types.habitats.Habitat;
import dmr.DragonMounts.util.type_adapters.AbilityAdapter;
import dmr.DragonMounts.util.type_adapters.BlockAdapter;
import dmr.DragonMounts.util.type_adapters.HabitatAdapter;
import dmr.DragonMounts.util.type_adapters.ItemAdapter;
import dmr.DragonMounts.util.type_adapters.ItemListAdapter;
import dmr.DragonMounts.util.type_adapters.ParticleOptionsAdapter;
import dmr.DragonMounts.util.type_adapters.SoundEventAdapter;
import java.lang.reflect.Method;
import java.util.List;
import lombok.Generated;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="dmr")
public class DMR {
    public static final String MOD_ID = "dmr";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"dmr");
    private static Gson Gson;
    public static boolean DEBUG;

    public DMR(IEventBus bus, ModContainer container) {
        DEBUG = !FMLLoader.isProduction();
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setPrettyPrinting();
        gsonBuilder.registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer());
        gsonBuilder.registerTypeAdapter(new TypeToken<List<Item>>(){}.getType(), (Object)new ItemListAdapter());
        gsonBuilder.registerTypeAdapter(Item.class, (Object)new ItemAdapter());
        gsonBuilder.registerTypeAdapter(RegisterColorHandlersEvent.Block.class, (Object)new BlockAdapter());
        gsonBuilder.registerTypeAdapter(ParticleOptions.class, (Object)new ParticleOptionsAdapter());
        gsonBuilder.registerTypeAdapter(SoundEvent.class, (Object)new SoundEventAdapter());
        gsonBuilder.registerTypeAdapter(Ability.class, (Object)new AbilityAdapter());
        gsonBuilder.registerTypeAdapter(Habitat.class, (Object)new HabitatAdapter());
        if (FMLEnvironment.dist == Dist.CLIENT) {
            container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.MOD_CONFIG_SPEC);
        }
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.MOD_CONFIG_SPEC);
        Gson = gsonBuilder.create();
        ModCreativeTabs.init();
        ModItems.init();
        ModBlocks.BLOCKS.register(bus);
        ModItems.ITEMS.register(bus);
        ModEntities.ENTITIES.register(bus);
        ModBlockEntities.BLOCK_ENTITIES.register(bus);
        ModSounds.SOUNDS.register(bus);
        ModCreativeTabs.CREATIVE_MODE_TABS.register(bus);
        ModMenus.MENU_TYPES.register(bus);
        ModCapabilities.ATTACHMENT_TYPES.register(bus);
        ModSensors.SENSORS.register(bus);
        ModMemoryModuleTypes.MEMORY_MODULE_TYPE.register(bus);
        ModComponents.COMPONENTS.register(bus);
        ModCriterionTriggers.CRITERION_TRIGGERS.register(bus);
        ModActivityTypes.ACTIVITIES.register(bus);
        ModCustomRecipes.RECIPES.register(bus);
        ModParticles.PARTICLE_TYPES.register(bus);
        bus.addListener(PacketRegistry::registerEvent);
        bus.addListener(DataPackHandler::newDataPack);
        NeoForge.EVENT_BUS.addListener(DataPackHandler::dataPackData);
        NeoForge.EVENT_BUS.addListener(LootTableInject::onLootLoad);
        NeoForge.EVENT_BUS.addListener(this::registerCommands);
        if (DEBUG) {
            try {
                Class<?> clas = Class.forName("dmr.DMRTestMod");
                Method method = clas.getMethod("registerTestFramework", IEventBus.class, ModContainer.class);
                method.invoke(null, bus, container);
            }
            catch (Exception e) {
                LOGGER.debug("Failed to register test framework.");
            }
        }
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        CommandDispatcher commandDispatcher = event.getDispatcher();
        DMRCommand.register((CommandDispatcher<CommandSourceStack>)commandDispatcher);
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    @Generated
    public static Gson getGson() {
        return Gson;
    }

    static {
        DEBUG = false;
    }
}

