/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.client.events;

import dmr.DragonMounts.client.handlers.KeyInputHandler;
import dmr.DragonMounts.config.ClientConfig;
import dmr.DragonMounts.network.packets.DragonAttackPacket;
import dmr.DragonMounts.network.packets.DragonBreathPacket;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME)
public class DragonAttackEvent {
    private static Long lastAttack = null;

    @SubscribeEvent
    public static void onClickEvent(InputEvent.InteractionKeyMappingTriggered event) {
        Entity entity;
        if (ClientConfig.USE_ALTERNATE_ATTACK_KEY && !KeyInputHandler.ATTACK_KEY.isDown()) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && (entity = player.getControlledVehicle()) instanceof TameableDragonEntity) {
            boolean didAttack;
            TameableDragonEntity dragon = (TameableDragonEntity)entity;
            boolean bl = didAttack = lastAttack == null || System.currentTimeMillis() - lastAttack > TimeUnit.MILLISECONDS.convert(1L, TimeUnit.SECONDS);
            if (event.isAttack()) {
                event.setCanceled(true);
                event.setSwingHand(false);
                if (didAttack) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new DragonAttackPacket(dragon.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            } else if (event.isUseItem()) {
                event.setCanceled(true);
                event.setSwingHand(false);
                if (didAttack) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new DragonBreathPacket(dragon.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            if (didAttack) {
                lastAttack = System.currentTimeMillis();
            }
        }
    }
}

