/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.client.model;

import dmr.DragonMounts.DMR;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import dmr.DragonMounts.types.dragonBreeds.IDragonBreed;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.loading.math.MathParser;
import software.bernie.geckolib.model.GeoModel;

public class DragonModel
extends GeoModel<TameableDragonEntity> {
    public ResourceLocation getModelResource(TameableDragonEntity object) {
        if (object != null && object.getBreed() != null && object.getBreed().getDragonModelLocation() != null) {
            return object.getBreed().getDragonModelLocation();
        }
        return DMR.id("geo/dragon.geo.json");
    }

    public ResourceLocation getTextureResource(TameableDragonEntity object) {
        IDragonBreed breed = object.getBreed();
        ResourceLocation breedResourceLocation = breed.getResourceLocation();
        if (object.hasVariant()) {
            return object.getVariant().skinTexture();
        }
        return DMR.id("textures/entity/dragon/" + breedResourceLocation.getPath() + "/body.png");
    }

    public ResourceLocation getAnimationResource(TameableDragonEntity animatable) {
        if (animatable != null && animatable.getBreed() != null && animatable.getBreed().getDragonAnimationLocation() != null) {
            return animatable.getBreed().getDragonAnimationLocation();
        }
        return DMR.id("animations/dragon.animation.json");
    }

    public void applyMolangQueries(AnimationState<TameableDragonEntity> animationState, double animTime) {
        super.applyMolangQueries(animationState, animTime);
        TameableDragonEntity dragon = (TameableDragonEntity)animationState.getAnimatable();
        MathParser.setVariable((String)"query.head_pitch", () -> dragon.getXRot() * 1.0f);
        MathParser.setVariable((String)"query.head_yaw", () -> (dragon.yBodyRot - dragon.yHeadRot) * -1.0f);
        Vec3 viewVector = dragon.getDeltaMovement().multiply(0.0, 0.25, 0.0);
        if (viewVector != null) {
            double pitch = viewVector.y;
            MathParser.setVariable((String)"query.pitch", () -> Mth.clamp((double)pitch, (double)-1.0, (double)1.0));
        }
    }
}

