/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dmr.DragonMounts.client.model.DragonEggModel;
import dmr.DragonMounts.config.ClientConfig;
import dmr.DragonMounts.server.blockentities.DMREggBlockEntity;
import dmr.DragonMounts.server.blocks.DMREggBlock;
import dmr.DragonMounts.types.dragonBreeds.DragonHybridBreed;
import dmr.DragonMounts.types.dragonBreeds.IDragonBreed;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.RenderTypeHelper;

public class DragonEggRenderer
implements BlockEntityRenderer<DMREggBlockEntity> {
    public void render(DMREggBlockEntity blockEntity, float v, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int i1) {
        if (!ClientConfig.RENDER_HATCHING_EGG) {
            return;
        }
        if (!((Boolean)blockEntity.getBlockState().getValue((Property)DMREggBlock.HATCHING)).booleanValue()) {
            return;
        }
        BakedModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(blockEntity.getBlockState());
        if (model instanceof DragonEggModel.Baked) {
            IDragonBreed iDragonBreed;
            DragonEggModel.Baked eggModel = (DragonEggModel.Baked)model;
            BakedModel bakedModel = (BakedModel)eggModel.models.getOrDefault((Object)blockEntity.getBreedId(), (Object)DragonEggModel.Baked.FALLBACK.get());
            poseStack.pushPose();
            int time = blockEntity.tickCount;
            float hatchProgress = (float)blockEntity.getHatchTime() / (float)blockEntity.getBreed().getHatchTime();
            float oscillationPeriod = 100.0f;
            float angle = (float)Math.sin((double)((float)time % oscillationPeriod) * (Math.PI * 2 / (double)oscillationPeriod)) * (2.0f + 5.0f * hatchProgress);
            poseStack.translate(0.5, 0.0, 0.5);
            poseStack.rotateAround(Axis.XN.rotationDegrees(angle), 0.0f, 0.0f, 0.0f);
            poseStack.translate(-0.5, 0.0, -0.5);
            RenderType renderType = RenderTypeHelper.getEntityRenderType((RenderType)((RenderType)model.getRenderTypes(blockEntity.getBlockState(), blockEntity.getLevel().random, blockEntity.getModelData()).asList().getFirst()), (boolean)true);
            if (blockEntity.getBreed() != null && (iDragonBreed = blockEntity.getBreed()) instanceof DragonHybridBreed) {
                DragonHybridBreed hybridBreed = (DragonHybridBreed)iDragonBreed;
                bakedModel = (BakedModel)eggModel.models.getOrDefault((Object)hybridBreed.parent1.getId(), (Object)DragonEggModel.Baked.FALLBACK.get());
            }
            Minecraft.getInstance().getBlockRenderer().getModelRenderer().renderModel(poseStack.last(), multiBufferSource.getBuffer(renderType), blockEntity.getBlockState(), Objects.requireNonNullElse(bakedModel, model), 0.0f, 0.0f, 0.0f, i, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
    }
}

