/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.common.events;

import dmr.DragonMounts.DMR;
import dmr.DragonMounts.common.capability.DragonOwnerCapability;
import dmr.DragonMounts.common.handlers.DragonWhistleHandler;
import dmr.DragonMounts.config.ServerConfig;
import dmr.DragonMounts.network.packets.CompleteDataSync;
import dmr.DragonMounts.network.packets.DragonNBTSync;
import dmr.DragonMounts.network.packets.DragonRespawnDelayPacket;
import dmr.DragonMounts.registry.ModCapabilities;
import dmr.DragonMounts.registry.ModItems;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import dmr.DragonMounts.server.worlddata.DragonWorldData;
import dmr.DragonMounts.server.worlddata.DragonWorldDataManager;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="dmr")
public class DragonWhistleEvent {
    @SubscribeEvent
    public static void onWorldTick(LevelTickEvent.Post event) {
        if (!event.getLevel().isClientSide) {
            DragonWorldData data = DragonWorldDataManager.getInstance(event.getLevel());
            for (UUID uuid : data.deadDragons) {
                if (data.deathDelay.get(uuid) <= 0) continue;
                data.deathDelay.put(uuid, data.deathDelay.get(uuid) - 1);
            }
            for (UUID uuid : new CopyOnWriteArrayList<UUID>(data.deadDragons)) {
                if (data.deathDelay.get(uuid) > 0) continue;
                DragonWorldDataManager.clearDragonData(event.getLevel(), uuid);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        if (!event.getLevel().isClientSide) {
            Entity player;
            Object object;
            TameableDragonEntity dragon;
            Entity entity = event.getEntity();
            if (entity instanceof TameableDragonEntity && (dragon = (TameableDragonEntity)entity).getOwner() != null && (object = dragon.getOwner()) instanceof Player) {
                player = (Player)object;
                DragonOwnerCapability cap = (DragonOwnerCapability)player.getData(ModCapabilities.PLAYER_CAPABILITY);
                int n = DragonWhistleHandler.getDragonSummonIndex((Player)player, dragon.getDragonUUID());
                if (cap.lastSummons != null && !cap.lastSummons.isEmpty() && cap.lastSummons.containsKey(n) && !cap.lastSummons.get(n).equals(dragon.getUUID())) {
                    DMR.LOGGER.debug("Preventing loading of dragon in {}, last entity id mismatch. Expected: {}, got: {}", new Object[]{event.getLevel().dimension().location(), cap.lastSummons.get(n), dragon.getDragonUUID()});
                    event.setCanceled(true);
                    return;
                }
            }
            if ((player = event.getEntity()) instanceof Player) {
                Player player2 = (Player)player;
                DragonOwnerCapability state = (DragonOwnerCapability)player2.getData(ModCapabilities.PLAYER_CAPABILITY);
                if (!state.dragonInstances.isEmpty()) {
                    for (Map.Entry entry : state.dragonInstances.entrySet()) {
                        boolean dragonWasKilled;
                        Integer index = (Integer)entry.getKey();
                        UUID id = ((DragonWhistleHandler.DragonInstance)entry.getValue()).getUUID();
                        if (player2 instanceof ServerPlayer) {
                            ServerPlayer spPlayer = (ServerPlayer)player2;
                            CompoundTag nbtData = state.dragonNBTs.get(index);
                            PacketDistributor.sendToPlayer((ServerPlayer)spPlayer, (CustomPacketPayload)new DragonNBTSync(index, nbtData), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        }
                        if (!(dragonWasKilled = DragonWorldDataManager.isDragonDead(event.getLevel(), id))) continue;
                        int dragonRespawnDelay = DragonWorldDataManager.getDeathDelay(event.getLevel(), id);
                        String message = DragonWorldDataManager.getDeathMessage(event.getLevel(), id);
                        MutableComponent mes = Component.Serializer.fromJsonLenient((String)message, (HolderLookup.Provider)event.getLevel().registryAccess());
                        if (mes != null) {
                            player2.displayClientMessage((Component)mes, false);
                        }
                        if (ServerConfig.ALLOW_RESPAWN) {
                            state.respawnDelays.put(index, dragonRespawnDelay);
                        } else {
                            state.dragonNBTs.remove(index);
                            state.respawnDelays.remove(index);
                            state.dragonInstances.remove(index);
                            if (player2 instanceof ServerPlayer) {
                                ServerPlayer spPlayer = (ServerPlayer)player2;
                                PacketDistributor.sendToPlayer((ServerPlayer)spPlayer, (CustomPacketPayload)new DragonNBTSync(index, new CompoundTag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            }
                        }
                        DragonWorldDataManager.clearDragonData(event.getLevel(), id);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(EntityTickEvent.Post event) {
        Entity entity;
        if (!event.getEntity().level.isClientSide && (entity = event.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            DragonOwnerCapability state = (DragonOwnerCapability)player.getData(ModCapabilities.PLAYER_CAPABILITY);
            for (Map.Entry<Integer, DragonWhistleHandler.DragonInstance> ent : state.dragonInstances.entrySet()) {
                Integer index = ent.getKey();
                UUID id = ent.getValue().getUUID();
                if (!state.respawnDelays.containsKey(index) || state.respawnDelays.get(index) <= 0) continue;
                state.respawnDelays.put(index, state.respawnDelays.get(index) - 1);
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new DragonRespawnDelayPacket(index, state.respawnDelays.get(index)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                if (state.respawnDelays.get(index) != 0) continue;
                DragonWorldDataManager.clearDragonData(player.level, id);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        LivingEntity livingEntity;
        if (!event.getEntity().level.isClientSide && (livingEntity = event.getEntity()) instanceof TameableDragonEntity) {
            LivingEntity livingEntity2;
            TameableDragonEntity dragon = (TameableDragonEntity)livingEntity;
            MutableComponent mes = ((MutableComponent)event.getSource().getLocalizedDeathMessage(event.getEntity())).withStyle(ChatFormatting.RED);
            if (dragon.getOwner() != null && (livingEntity2 = dragon.getOwner()) instanceof Player) {
                Player player = (Player)livingEntity2;
                player.displayClientMessage((Component)mes, false);
                int index = DragonWhistleHandler.getDragonSummonIndex(player, dragon.getDragonUUID());
                if (!ServerConfig.ALLOW_RESPAWN) {
                    DragonOwnerCapability state = (DragonOwnerCapability)player.getData(ModCapabilities.PLAYER_CAPABILITY);
                    state.dragonInstances.remove(index);
                    state.dragonNBTs.remove(index);
                    state.respawnDelays.remove(index);
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new CompleteDataSync(player), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else if (ServerConfig.RESPAWN_TIME > 0) {
                    DragonOwnerCapability state = (DragonOwnerCapability)player.getData(ModCapabilities.PLAYER_CAPABILITY);
                    state.respawnDelays.put(index, ServerConfig.RESPAWN_TIME * 20);
                    Item whistle = ModItems.DRAGON_WHISTLES.get(index).get();
                    if (!player.getCooldowns().isOnCooldown(whistle)) {
                        player.getCooldowns().addCooldown(whistle, ServerConfig.RESPAWN_TIME * 20);
                    }
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new CompleteDataSync(player), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                }
            } else {
                DragonWorldDataManager.setDragonDead(dragon, Component.Serializer.toJson((Component)mes, (HolderLookup.Provider)event.getEntity().level.registryAccess()));
            }
        }
    }
}

