/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.data;

import dmr.DragonMounts.data.BlockTagProvider;
import dmr.DragonMounts.data.DMRItemModelProvider;
import dmr.DragonMounts.data.DMRRecipeProvider;
import dmr.DragonMounts.data.EntityTagProvider;
import dmr.DragonMounts.registry.ModEntities;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(modid="dmr", bus=EventBusSubscriber.Bus.MOD)
public class DataProvider {
    public static final ResourceKey<BiomeModifier> DRAGON_SPAWNS_OVERWORLD = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"dmr", (String)"dragon_spawns_overworld"));
    public static final ResourceKey<BiomeModifier> DRAGON_SPAWNS_NETHER = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"dmr", (String)"dragon_spawns_nether"));
    public static final ResourceKey<BiomeModifier> DRAGON_SPAWNS_END = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"dmr", (String)"dragon_spawns_end"));

    @SubscribeEvent
    public static void gather(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture registries = event.getLookupProvider();
        RegistrySetBuilder BUILDER = new RegistrySetBuilder();
        BUILDER.add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, bootstrap -> {
            HolderGetter biomes = bootstrap.lookup(Registries.BIOME);
            List<MobSpawnSettings.SpawnerData> spawners = List.of(new MobSpawnSettings.SpawnerData(ModEntities.DRAGON_ENTITY.get(), 1, 1, 2));
            bootstrap.register(DRAGON_SPAWNS_OVERWORLD, (Object)new BiomeModifiers.AddSpawnsBiomeModifier((HolderSet)biomes.getOrThrow(Tags.Biomes.IS_OVERWORLD), spawners));
            bootstrap.register(DRAGON_SPAWNS_NETHER, (Object)new BiomeModifiers.AddSpawnsBiomeModifier((HolderSet)biomes.getOrThrow(Tags.Biomes.IS_NETHER), spawners));
            bootstrap.register(DRAGON_SPAWNS_END, (Object)new BiomeModifiers.AddSpawnsBiomeModifier((HolderSet)biomes.getOrThrow(Tags.Biomes.IS_END), spawners));
        });
        DatapackBuiltinEntriesProvider builtinEntriesProvider = new DatapackBuiltinEntriesProvider(output, registries, BUILDER, Set.of("dmr"));
        generator.addProvider(event.includeServer(), (net.minecraft.data.DataProvider)builtinEntriesProvider);
        generator.addProvider(event.includeServer(), (net.minecraft.data.DataProvider)new BlockTagProvider(output, event.getLookupProvider(), "dmr", existingFileHelper));
        generator.addProvider(event.includeServer(), (net.minecraft.data.DataProvider)new EntityTagProvider(output, event.getLookupProvider(), "dmr", existingFileHelper));
        generator.addProvider(event.includeServer(), (net.minecraft.data.DataProvider)new DMRRecipeProvider(output, event.getLookupProvider()));
        generator.addProvider(event.includeServer(), (net.minecraft.data.DataProvider)new DMRItemModelProvider(output, "dmr", existingFileHelper));
    }
}

