/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.network;

import dmr.DragonMounts.DMR;
import dmr.DragonMounts.network.IMessage;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class PacketHelper {
    public static <T extends CustomPacketPayload> CustomPacketPayload.Type<T> createType(String name) {
        return new CustomPacketPayload.Type(DMR.id(name));
    }

    public static <T> StreamCodec<FriendlyByteBuf, T> createUnitCodec(final T packet) {
        return new StreamCodec<FriendlyByteBuf, T>(){

            public T decode(FriendlyByteBuf buffer) {
                return packet;
            }

            public void encode(FriendlyByteBuf buffer, T value) {
            }
        };
    }

    public static <T> StreamCodec<FriendlyByteBuf, T> createCodec(final BiConsumer<FriendlyByteBuf, T> encoder, final Function<FriendlyByteBuf, T> decoder) {
        return new StreamCodec<FriendlyByteBuf, T>(){

            public T decode(FriendlyByteBuf buffer) {
                return decoder.apply(buffer);
            }

            public void encode(FriendlyByteBuf buffer, T value) {
                encoder.accept(buffer, value);
            }
        };
    }

    public static <T, F> StreamCodec<FriendlyByteBuf, T> createSingleFieldCodec(StreamCodec<FriendlyByteBuf, F> codec, Function<T, F> getter, Function<F, T> constructor) {
        return StreamCodec.composite(codec, getter, constructor);
    }

    public static <T, F1, F2> StreamCodec<FriendlyByteBuf, T> createTwoFieldCodec(StreamCodec<FriendlyByteBuf, F1> codec1, Function<T, F1> getter1, StreamCodec<FriendlyByteBuf, F2> codec2, Function<T, F2> getter2, BiFunction<F1, F2, T> constructor) {
        return StreamCodec.composite(codec1, getter1, codec2, getter2, constructor);
    }

    public static <T extends IMessage<T>> void registerPacket(PayloadRegistrar registrar, T packet) {
        CustomPacketPayload.Type type = packet.type();
        registrar.playBidirectional(type, packet.streamCodec(), PacketHelper::handlePacket);
    }

    private static void handlePacket(CustomPacketPayload payload, IPayloadContext context) {
        if (!(payload instanceof IMessage)) {
            return;
        }
        IMessage message = (IMessage)payload;
        if (context.flow().isClientbound()) {
            context.enqueueWork(() -> {
                Player player = context.player();
                if (player != null) {
                    message.handle(context, player);
                    message.handleClient(context, player);
                }
            });
        }
        if (context.flow().isServerbound()) {
            Player player = context.player();
            if (player == null) {
                return;
            }
            message.handle(context, player);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                message.handleServer(context, serverPlayer);
            }
            if (message.autoSync()) {
                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static <T extends IMessage<T>> void sendToServer(T packet) {
        PacketDistributor.sendToServer(packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static <T extends IMessage<T>> void sendToPlayer(T packet, ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static <T extends IMessage<T>> void sendToAll(T packet) {
        PacketDistributor.sendToAllPlayers(packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static <T extends IMessage<T>> void sendToAllTracking(T packet, Entity entity) {
        PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static <T extends IMessage<T>> void sendToAllTrackingAndSelf(T packet, Entity entity) {
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

