/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.network.packets;

import dmr.DragonMounts.common.capability.DragonOwnerCapability;
import dmr.DragonMounts.network.AbstractMessage;
import dmr.DragonMounts.registry.ModCapabilities;
import dmr.DragonMounts.util.PlayerStateUtils;
import lombok.Generated;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class CompleteDataSync
extends AbstractMessage<CompleteDataSync> {
    private static final StreamCodec<FriendlyByteBuf, CompleteDataSync> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, CompleteDataSync::getPlayerId, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, CompleteDataSync::getTag, CompleteDataSync::new);
    private final int playerId;
    private final CompoundTag tag;

    CompleteDataSync() {
        this.playerId = -1;
        this.tag = new CompoundTag();
    }

    public CompleteDataSync(int playerId, CompoundTag tag) {
        this.playerId = playerId;
        this.tag = tag;
    }

    public CompleteDataSync(Player player) {
        this(player.getId(), ((DragonOwnerCapability)player.getData(ModCapabilities.PLAYER_CAPABILITY)).serializeNBT((HolderLookup.Provider)player.level.registryAccess()));
    }

    @Override
    protected String getTypeName() {
        return "complete_data_sync";
    }

    @Override
    public StreamCodec<? super RegistryFriendlyByteBuf, CompleteDataSync> streamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public boolean autoSync() {
        return true;
    }

    @Override
    public void handle(IPayloadContext supplier, Player player) {
        PlayerStateUtils.getHandler(player).deserializeNBT((HolderLookup.Provider)player.level.registryAccess(), this.tag);
        player.refreshDimensions();
    }

    @Generated
    public int getPlayerId() {
        return this.playerId;
    }

    @Generated
    public CompoundTag getTag() {
        return this.tag;
    }
}

