/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.network.packets;

import dmr.DragonMounts.network.AbstractMessage;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import lombok.Generated;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class DragonAgeSyncPacket
extends AbstractMessage<DragonAgeSyncPacket> {
    private static final StreamCodec<FriendlyByteBuf, DragonAgeSyncPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, DragonAgeSyncPacket::getDragonId, (StreamCodec)ByteBufCodecs.INT, DragonAgeSyncPacket::getAge, DragonAgeSyncPacket::new);
    private final int dragonId;
    private final int age;

    DragonAgeSyncPacket() {
        this.dragonId = -1;
        this.age = -1;
    }

    public DragonAgeSyncPacket(int dragonId, int age) {
        this.dragonId = dragonId;
        this.age = age;
    }

    @Override
    protected String getTypeName() {
        return "age_sync";
    }

    @Override
    public StreamCodec<? super RegistryFriendlyByteBuf, DragonAgeSyncPacket> streamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public void handle(IPayloadContext context, Player player) {
        Entity dragon = player.level.getEntity(this.dragonId);
        if (dragon instanceof TameableDragonEntity) {
            TameableDragonEntity dragonEntity = (TameableDragonEntity)dragon;
            dragonEntity.setAge(this.age);
        }
    }

    @Generated
    public int getDragonId() {
        return this.dragonId;
    }

    @Generated
    public int getAge() {
        return this.age;
    }
}

