/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.network.packets;

import dmr.DragonMounts.network.AbstractMessage;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import java.util.List;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class DragonBreathPacket
extends AbstractMessage<DragonBreathPacket> {
    private static final StreamCodec<FriendlyByteBuf, DragonBreathPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, DragonBreathPacket::getEntityId, DragonBreathPacket::new);
    private final int entityId;

    DragonBreathPacket() {
        this.entityId = -1;
    }

    public DragonBreathPacket(int entityId) {
        this.entityId = entityId;
    }

    @Override
    protected String getTypeName() {
        return "dragon_breath";
    }

    @Override
    public StreamCodec<? super RegistryFriendlyByteBuf, DragonBreathPacket> streamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public void handle(IPayloadContext context, Player player) {
        Level level = player.level;
        Entity entity = player.level.getEntity(this.entityId);
        if (entity instanceof TameableDragonEntity) {
            BlockPos blockPos;
            BlockState blockState;
            TameableDragonEntity dragon = (TameableDragonEntity)entity;
            Vec3 eyePos = player.getEyePosition();
            Vec3 lookVector = player.getLookAngle();
            Vec3 targetPos = eyePos.add(lookVector.scale(10.0));
            double searchDistance = 10.0;
            AABB searchBox = player.getBoundingBox().inflate(searchDistance);
            List potentialTargets = level.getEntities((Entity)player, searchBox, ent -> {
                LivingEntity livingEntity;
                return ent instanceof LivingEntity && dragon.canHarmWithBreath(livingEntity = (LivingEntity)ent);
            });
            LivingEntity closestTarget = null;
            double closestDistance = Double.MAX_VALUE;
            for (Entity potentialTarget : potentialTargets) {
                double distance;
                Vec3 directionToTarget = potentialTarget.position().subtract(eyePos).normalize();
                double dotProduct = directionToTarget.dot(lookVector);
                if (!(dotProduct > 0.7) || !((distance = potentialTarget.distanceToSqr(eyePos)) < closestDistance)) continue;
                closestDistance = distance;
                closestTarget = (LivingEntity)potentialTarget;
            }
            if (closestTarget != null) {
                dragon.setBreathAttackTarget(closestTarget);
                return;
            }
            ClipContext clipContext = new ClipContext(eyePos, targetPos, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)player);
            BlockHitResult blockHitResult = level.clip(clipContext);
            if (blockHitResult.getType() == HitResult.Type.BLOCK && !(blockState = level.getBlockState(blockPos = blockHitResult.getBlockPos())).isAir()) {
                dragon.setBreathAttackBlock(blockPos);
                return;
            }
            dragon.setBreathAttackPosition(targetPos);
        }
    }

    @Generated
    public int getEntityId() {
        return this.entityId;
    }
}

