/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.ai;

import dmr.DragonMounts.server.entity.TameableDragonEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.common.NeoForgeMod;

public class DragonMoveController
extends MoveControl {
    private final TameableDragonEntity dragon;

    public DragonMoveController(TameableDragonEntity dragon) {
        super((Mob)dragon);
        this.dragon = dragon;
        this.speedModifier = 4.0;
    }

    public void tick() {
        if (this.operation == MoveControl.Operation.MOVE_TO) {
            this.operation = MoveControl.Operation.WAIT;
            double xDif = this.wantedX - this.mob.getX();
            double zDif = this.wantedZ - this.mob.getZ();
            double yDif = this.wantedY - this.mob.getY();
            double sq = xDif * xDif + yDif * yDif + zDif * zDif;
            if (sq < 2.500000277905201E-7) {
                this.mob.setYya(0.0f);
                this.mob.setZza(0.0f);
                return;
            }
            boolean isAmphibious = !this.dragon.canDrownInFluidType(Fluids.WATER.getFluidType());
            boolean isInWater = this.mob.isInWater();
            BlockPos blockpos = this.mob.blockPosition();
            BlockState blockstate = this.mob.level.getBlockState(blockpos);
            boolean shouldFly = !blockstate.isSolid() && this.dragon.canFly() && (!blockstate.is(Blocks.WATER) || !isAmphibious);
            this.dragon.setNoGravity(shouldFly || isInWater);
            this.dragon.setFlying(shouldFly);
            float f9 = (float)(Mth.atan2((double)zDif, (double)xDif) * 180.0 / 3.1415927410125732) - 90.0f;
            this.mob.setYRot(this.rotlerp(this.mob.getYRot(), f9, 10.0f));
            float speed = this.mob.onGround() ? (float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED)) : (isInWater ? (float)(this.speedModifier * this.mob.getAttributeValue(NeoForgeMod.SWIM_SPEED)) : (float)(this.speedModifier * this.mob.getAttributeValue(Attributes.FLYING_SPEED)));
            if (!isInWater && this.mob.getNavigation().getPath() != null) {
                this.mob.getNavigation().getPath().getNextNode();
                PathType type = this.mob.getNavigation().getPath().getNextNode().type;
                if (type == PathType.WATER || type == PathType.WATER_BORDER) {
                    isInWater = true;
                }
            }
            this.mob.setSpeed(speed);
            double d4 = Math.sqrt(xDif * xDif + zDif * zDif);
            if (isInWater) {
                if (Math.abs(yDif) > (double)1.0E-5f || Math.abs(d4) > (double)1.0E-5f) {
                    float f3 = -((float)(Mth.atan2((double)yDif, (double)d4) * 180.0 / 3.1415927410125732));
                    f3 = Mth.clamp((float)Mth.wrapDegrees((float)f3), (float)-85.0f, (float)10.0f);
                    this.mob.setXRot(this.rotlerp(this.mob.getXRot(), f3, 5.0f));
                }
                float f6 = Mth.cos((float)(this.mob.getXRot() * ((float)Math.PI / 180)));
                float f4 = Mth.sin((float)(this.mob.getXRot() * ((float)Math.PI / 180)));
                this.mob.zza = f6 * speed;
                this.mob.yya = -f4 * speed * 5.0f;
            } else if (Math.abs(yDif) > (double)1.0E-5f || Math.abs(d4) > (double)1.0E-5f) {
                this.mob.setYya(yDif > 0.0 ? speed : -speed);
            }
        } else if (this.operation == MoveControl.Operation.WAIT) {
            this.mob.setYya(0.0f);
            this.mob.setZza(0.0f);
            this.mob.setXxa(0.0f);
        } else {
            super.tick();
        }
    }
}

