/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.ai.behaviours;

import com.google.common.collect.ImmutableMap;
import dmr.DragonMounts.registry.ModMemoryModuleTypes;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class DragonBreathAttack
extends Behavior<TameableDragonEntity> {
    private static final int ATTACK_DURATION = (int)(TameableDragonEntity.getBreathLength() * 20.0);
    private static final int COOLDOWN_DURATION = 200;
    private Behavior.Status status = Behavior.Status.STOPPED;

    public DragonBreathAttack() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT, ModMemoryModuleTypes.HAS_BREATH_COOLDOWN.get(), (Object)MemoryStatus.VALUE_ABSENT), ATTACK_DURATION);
    }

    public Behavior.Status getStatus() {
        return this.status;
    }

    protected void start(ServerLevel level, TameableDragonEntity entity, long gameTime) {
        Optional target = entity.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET);
        entity.setBreathAttackTarget((LivingEntity)target.get());
        entity.getBrain().setMemoryWithExpiry(ModMemoryModuleTypes.HAS_BREATH_COOLDOWN.get(), (Object)true, 200L);
        this.status = Behavior.Status.RUNNING;
    }

    protected boolean canStillUse(ServerLevel level, TameableDragonEntity entity, long gameTime) {
        return entity.hasBreathTarget();
    }

    protected void stop(ServerLevel level, TameableDragonEntity entity, long gameTime) {
        this.status = Behavior.Status.STOPPED;
    }
}

