/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.ai.navigation;

import dmr.DragonMounts.server.ai.navigation.DragonNodeEvaluator;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public class DragonPathNavigation
extends FlyingPathNavigation {
    private DragonNodeEvaluator dragonNodeEvaluator;

    public DragonPathNavigation(Mob pMob, Level pLevel) {
        super(pMob, pLevel);
    }

    protected PathFinder createPathFinder(int pMaxVisitedNodes) {
        this.dragonNodeEvaluator = new DragonNodeEvaluator(this.mob);
        this.nodeEvaluator = this.dragonNodeEvaluator;
        return new PathFinder(this.nodeEvaluator, pMaxVisitedNodes);
    }

    public boolean canCutCorner(PathType pathType) {
        return super.canCutCorner(pathType) || pathType == PathType.WATER;
    }

    protected Vec3 getTempMobPos() {
        return this.mob.position().subtract(0.0, 0.0, 0.0);
    }

    protected double getGroundY(Vec3 p_217794_) {
        return this.dragonNodeEvaluator.allowSwimming ? p_217794_.y : super.getGroundY(p_217794_);
    }

    @Nullable
    public Path createPath(BlockPos pos, int accuracy) {
        Path path;
        this.dragonNodeEvaluator.allowSwimming = false;
        this.dragonNodeEvaluator.allowFlying = false;
        this.setMaxVisitedNodesMultiplier(5.0f);
        Mob mob = this.mob;
        if (mob instanceof TameableDragonEntity) {
            TameableDragonEntity dragon = (TameableDragonEntity)mob;
            boolean bl = this.dragonNodeEvaluator.allowSwimming = dragon.getBreed() != null && dragon.getBreed().getImmunities().contains("drown") && dragon.level.getFluidState(pos).is(Tags.Fluids.WATER);
        }
        if ((path = super.createPath(pos, accuracy)) == null || !path.canReach() || path.getNodeCount() <= 1) {
            int dif = this.mob.blockPosition().getY() - pos.getY();
            double jumpHeight = Math.max(1.125, (double)this.mob.maxUpStep());
            if ((double)Mth.abs((int)dif) >= jumpHeight) {
                this.dragonNodeEvaluator.allowFlying = true;
                path = super.createPath(pos, accuracy);
            }
        }
        this.resetMaxVisitedNodesMultiplier();
        return path;
    }

    public Path createPath(Entity entity, int accuracy) {
        Path path;
        this.dragonNodeEvaluator.allowSwimming = false;
        this.dragonNodeEvaluator.allowFlying = false;
        this.setMaxVisitedNodesMultiplier(5.0f);
        Mob mob = this.mob;
        if (mob instanceof TameableDragonEntity) {
            TameableDragonEntity dragon = (TameableDragonEntity)mob;
            boolean bl = this.dragonNodeEvaluator.allowSwimming = dragon.getBreed() != null && dragon.getBreed().getImmunities().contains("drown") && entity.isInWater();
        }
        if ((path = super.createPath(entity, accuracy)) == null || !path.canReach() || path.getNodeCount() <= 1) {
            int dif = this.mob.blockPosition().getY() - entity.blockPosition().getY();
            double jumpHeight = Math.max(1.125, (double)this.mob.maxUpStep());
            if ((double)Mth.abs((int)dif) >= jumpHeight) {
                this.dragonNodeEvaluator.allowFlying = true;
                path = super.createPath(entity, accuracy);
            }
        }
        this.resetMaxVisitedNodesMultiplier();
        return path;
    }

    protected boolean canUpdatePath() {
        return true;
    }

    protected boolean canMoveDirectly(Vec3 p_217796_, Vec3 p_217797_) {
        return this.dragonNodeEvaluator.allowSwimming && this.mob.isInLiquid() && DragonPathNavigation.isClearForMovementBetween((Mob)this.mob, (Vec3)p_217796_, (Vec3)p_217797_, (boolean)true);
    }

    public boolean isStableDestination(BlockPos pPos) {
        if (this.dragonNodeEvaluator.allowFlying) {
            return this.level.getBlockState(pPos).entityCanStandOn((BlockGetter)this.level, pPos, (Entity)this.mob);
        }
        if (this.dragonNodeEvaluator.allowSwimming) {
            return !this.level.getBlockState(pPos.below()).isAir();
        }
        BlockPos blockpos = pPos.below();
        return this.level.getBlockState(blockpos).isSolidRender((BlockGetter)this.level, blockpos);
    }
}

