/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.container;

import dmr.DragonMounts.registry.ModMenus;
import dmr.DragonMounts.server.container.slots.DragonInventorySlot;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class DragonContainerMenu
extends AbstractContainerMenu {
    private final Container dragonContainer;
    public final TameableDragonEntity dragon;
    private final List<DragonInventorySlot> inventorySlots = new ArrayList<DragonInventorySlot>();

    public DragonContainerMenu(int pContainerId, Inventory pPlayerInventory, FriendlyByteBuf data) {
        super(ModMenus.DRAGON_MENU.get(), pContainerId);
        this.dragon = (TameableDragonEntity)pPlayerInventory.player.level.getEntity(data.readInt());
        if (this.dragon == null) {
            throw new IllegalStateException("Dragon is null");
        }
        this.dragonContainer = this.dragon.getInventory();
        this.dragonContainer.startOpen(pPlayerInventory.player);
        this.addSlot(new Slot(this.dragonContainer, 0, 102, 18){

            public boolean mayPlace(ItemStack p_39677_) {
                return p_39677_.is(Items.SADDLE) && !this.hasItem() && DragonContainerMenu.this.dragon.isSaddleable();
            }

            public boolean isActive() {
                return DragonContainerMenu.this.dragon.isSaddleable();
            }

            public void set(ItemStack pStack) {
                super.set(pStack);
                DragonContainerMenu.this.dragon.updateContainerEquipment();
                this.setChanged();
            }
        });
        this.addSlot(new Slot(this.dragonContainer, 1, 120, 18){

            public boolean mayPlace(ItemStack p_39690_) {
                return DragonContainerMenu.this.dragon.isArmor(p_39690_);
            }

            public int getMaxStackSize() {
                return 1;
            }

            public void set(ItemStack pStack) {
                super.set(pStack);
                DragonContainerMenu.this.dragon.updateContainerEquipment();
            }
        });
        this.addSlot(new Slot(this.dragonContainer, 2, 138, 18){

            public boolean mayPickup(Player pPlayer) {
                return DragonContainerMenu.this.dragon.inventoryEmpty() || DragonContainerMenu.this.dragon.getInventory().getItem(2).is(Items.ENDER_CHEST);
            }

            public boolean mayPlace(ItemStack p_39690_) {
                return p_39690_.is(Items.CHEST) || p_39690_.is(Items.ENDER_CHEST);
            }

            public void set(ItemStack pStack) {
                super.set(pStack);
                DragonContainerMenu.this.dragon.updateContainerEquipment();
                for (DragonInventorySlot slot : DragonContainerMenu.this.inventorySlots) {
                    slot.setChestTypeChanged(DragonContainerMenu.this.dragon.getInventory().getItem(2).is(Items.ENDER_CHEST));
                }
            }

            public int getMaxStackSize() {
                return 1;
            }
        });
        for (int k = 0; k < 3; ++k) {
            for (int l = 0; l < 9; ++l) {
                DragonInventorySlot chestSlot = new DragonInventorySlot(l + k * 9, 102 + l * 18, 53 + k * 18, this.dragonContainer, (Container)pPlayerInventory.player.getEnderChestInventory()){

                    public boolean isActive() {
                        return DragonContainerMenu.this.dragon.hasChest();
                    }
                };
                this.addSlot(chestSlot);
                this.inventorySlots.add(chestSlot);
            }
        }
        for (DragonInventorySlot slot : this.inventorySlots) {
            slot.setChestTypeChanged(this.dragon.getInventory().getItem(2).is(Items.ENDER_CHEST));
        }
        for (int i1 = 0; i1 < 3; ++i1) {
            for (int k1 = 0; k1 < 9; ++k1) {
                this.addSlot(new Slot((Container)pPlayerInventory, k1 + i1 * 9 + 9, 102 + k1 * 18, 123 + i1 * 18));
            }
        }
        for (int j1 = 0; j1 < 9; ++j1) {
            this.addSlot(new Slot((Container)pPlayerInventory, j1, 102 + j1 * 18, 181));
        }
    }

    public boolean stillValid(Player pPlayer) {
        return !this.dragon.hasInventoryChanged(this.dragonContainer) && this.dragonContainer.stillValid(pPlayer) && this.dragon.isAlive() && this.dragon.distanceTo((Entity)pPlayer) < 8.0f;
    }

    public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(pIndex);
        if (slot != null && slot.hasItem()) {
            int i;
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            int n = i = this.dragon.hasChest() ? this.dragonContainer.getContainerSize() : 3;
            if (pIndex < i) {
                if (!this.moveItemStackTo(itemstack1, i, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.getSlot(2).mayPlace(itemstack1) && !this.getSlot(2).hasItem()) {
                if (!this.moveItemStackTo(itemstack1, 1, 3, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.getSlot(1).mayPlace(itemstack1) && !this.getSlot(1).hasItem()) {
                if (!this.moveItemStackTo(itemstack1, 1, 3, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.getSlot(0).mayPlace(itemstack1)) {
                if (!this.moveItemStackTo(itemstack1, 0, 1, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (i <= 3 || !this.moveItemStackTo(itemstack1, 3, i, false)) {
                int j = i + 27;
                int k = j + 9;
                if (pIndex >= j && pIndex < k ? !this.moveItemStackTo(itemstack1, i, j, false) : (pIndex < j ? !this.moveItemStackTo(itemstack1, j, k, false) : !this.moveItemStackTo(itemstack1, j, j, false))) {
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public void removed(Player pPlayer) {
        super.removed(pPlayer);
        this.dragonContainer.stopOpen(pPlayer);
    }
}

