/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.entity.dragon;

import dmr.DragonMounts.config.ServerConfig;
import dmr.DragonMounts.server.blockentities.DMREggBlockEntity;
import dmr.DragonMounts.server.entity.DragonConstants;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import dmr.DragonMounts.server.entity.dragon.DragonSpawnComponent;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.common.NeoForgeMod;
import org.jetbrains.annotations.Nullable;

abstract class DragonAttributeComponent
extends DragonSpawnComponent {
    public static final EntityDataAccessor<Float> healthAttribute = SynchedEntityData.defineId(DragonAttributeComponent.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> speedAttribute = SynchedEntityData.defineId(DragonAttributeComponent.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> damageAttribute = SynchedEntityData.defineId(DragonAttributeComponent.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> maxScaleAttribute = SynchedEntityData.defineId(DragonAttributeComponent.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final ResourceLocation SCALE_MODIFIER = ResourceLocation.fromNamespaceAndPath((String)"dmr", (String)"scale_attribute");
    private static final ResourceLocation RANDOM_STATS_MODIFIER = ResourceLocation.fromNamespaceAndPath((String)"dmr", (String)"random_stats_attribute");

    protected DragonAttributeComponent(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.entityData.set(healthAttribute, (Object)Float.valueOf((float)Math.random()));
        this.entityData.set(speedAttribute, (Object)Float.valueOf((float)Math.random()));
        this.entityData.set(damageAttribute, (Object)Float.valueOf((float)Math.random()));
        this.entityData.set(maxScaleAttribute, (Object)Float.valueOf((float)Math.random()));
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor accessor, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.entityData.set(healthAttribute, (Object)Float.valueOf((float)Math.random()));
        this.entityData.set(speedAttribute, (Object)Float.valueOf((float)Math.random()));
        this.entityData.set(damageAttribute, (Object)Float.valueOf((float)Math.random()));
        this.entityData.set(maxScaleAttribute, (Object)Float.valueOf((float)Math.random()));
        return super.finalizeSpawn(accessor, difficulty, spawnType, spawnGroupData);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(healthAttribute, (Object)Float.valueOf(0.0f));
        builder.define(speedAttribute, (Object)Float.valueOf(0.0f));
        builder.define(damageAttribute, (Object)Float.valueOf(0.0f));
        builder.define(maxScaleAttribute, (Object)Float.valueOf(0.0f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, DragonConstants.BASE_SPEED_GROUND).add(Attributes.MAX_HEALTH, DragonConstants.BASE_HEALTH).add(Attributes.FOLLOW_RANGE, DragonConstants.BASE_FOLLOW_RANGE).add(Attributes.KNOCKBACK_RESISTANCE, (double)DragonConstants.BASE_KB_RESISTANCE).add(Attributes.ATTACK_DAMAGE, DragonConstants.BASE_DAMAGE).add(Attributes.FLYING_SPEED, DragonConstants.BASE_SPEED_FLYING).add(NeoForgeMod.SWIM_SPEED, DragonConstants.BASE_SPEED_WATER);
    }

    @Override
    public void tick() {
        super.tick();
        this.setBaseValue((Holder<Attribute>)Attributes.MAX_HEALTH, ServerConfig.BASE_HEALTH);
        this.setBaseValue((Holder<Attribute>)Attributes.ATTACK_DAMAGE, ServerConfig.BASE_DAMAGE);
        this.setBaseValue((Holder<Attribute>)Attributes.MOVEMENT_SPEED, DragonConstants.BASE_SPEED_GROUND * ServerConfig.BASE_SPEED);
        this.setRandomStats();
    }

    public void setRandomStats() {
        AttributeModifier randomStatsHealth = new AttributeModifier(RANDOM_STATS_MODIFIER, (double)this.upperLower((double)((Float)this.entityData.get(healthAttribute)).floatValue(), ServerConfig.LOWER_MAX_HEALTH, ServerConfig.UPPER_MAX_HEALTH), AttributeModifier.Operation.ADD_VALUE);
        AttributeInstance healthInstance = this.getAttribute(Attributes.MAX_HEALTH);
        if (!healthInstance.hasModifier(RANDOM_STATS_MODIFIER) || healthInstance.getModifier(RANDOM_STATS_MODIFIER).amount() != randomStatsHealth.amount()) {
            if (healthInstance.hasModifier(RANDOM_STATS_MODIFIER)) {
                healthInstance.removeModifier(RANDOM_STATS_MODIFIER);
            }
            healthInstance.addTransientModifier(randomStatsHealth);
        }
        AttributeModifier randomStatsDamage = new AttributeModifier(RANDOM_STATS_MODIFIER, this.upperLower((double)((Float)this.entityData.get(damageAttribute)).floatValue(), ServerConfig.LOWER_DAMAGE, ServerConfig.UPPER_DAMAGE), AttributeModifier.Operation.ADD_VALUE);
        AttributeInstance damageInstance = this.getAttribute(Attributes.ATTACK_DAMAGE);
        if (!damageInstance.hasModifier(RANDOM_STATS_MODIFIER) || damageInstance.getModifier(RANDOM_STATS_MODIFIER).amount() != randomStatsDamage.amount()) {
            if (damageInstance.hasModifier(RANDOM_STATS_MODIFIER)) {
                damageInstance.removeModifier(RANDOM_STATS_MODIFIER);
            }
            damageInstance.addTransientModifier(randomStatsDamage);
        }
        AttributeModifier randomStatsSpeed = new AttributeModifier(RANDOM_STATS_MODIFIER, this.upperLower((double)((Float)this.entityData.get(speedAttribute)).floatValue(), ServerConfig.LOWER_SPEED, ServerConfig.UPPER_SPEED), AttributeModifier.Operation.ADD_VALUE);
        AttributeInstance speedInstance = this.getAttribute(Attributes.MOVEMENT_SPEED);
        if (!speedInstance.hasModifier(RANDOM_STATS_MODIFIER) || speedInstance.getModifier(RANDOM_STATS_MODIFIER).amount() != randomStatsSpeed.amount()) {
            if (speedInstance.hasModifier(RANDOM_STATS_MODIFIER)) {
                speedInstance.removeModifier(RANDOM_STATS_MODIFIER);
            }
            speedInstance.addTransientModifier(randomStatsSpeed);
        }
    }

    public void updateAgeAttributes() {
        this.setBaseValue((Holder<Attribute>)Attributes.STEP_HEIGHT, Math.max(2.0f * this.getAgeProgress(), 1.0f));
        AttributeModifier mod = new AttributeModifier(SCALE_MODIFIER, (double)this.getScale(), AttributeModifier.Operation.ADD_VALUE);
        List<Holder> attributes = List.of(Attributes.MAX_HEALTH, Attributes.ATTACK_DAMAGE);
        for (Holder attribute : attributes) {
            AttributeInstance instance = this.getAttribute(attribute);
            if (instance == null || instance.hasModifier(SCALE_MODIFIER) && instance.getModifier(SCALE_MODIFIER).amount() == mod.amount()) continue;
            if (instance.hasModifier(SCALE_MODIFIER)) {
                instance.removeModifier(SCALE_MODIFIER);
            }
            instance.addTransientModifier(mod);
        }
    }

    private void setBaseValue(Holder<Attribute> attribute, double value) {
        AttributeInstance instance = this.getAttribute(attribute);
        if (instance == null) {
            return;
        }
        if (instance.getBaseValue() != value) {
            instance.setBaseValue(value);
        }
    }

    public void setEggBreedAttributes(TameableDragonEntity mate, Supplier<DMREggBlockEntity> eggBlockEntitySupplier) {
        float lowestHealth = Math.min(((Float)this.entityData.get(healthAttribute)).floatValue(), ((Float)mate.entityData.get(healthAttribute)).floatValue());
        float highestHealth = Math.max(((Float)this.entityData.get(healthAttribute)).floatValue(), ((Float)mate.entityData.get(healthAttribute)).floatValue());
        eggBlockEntitySupplier.get().setHealthAttribute(this.randomUpperLower(lowestHealth, highestHealth));
        float lowestSpeed = Math.min(((Float)this.entityData.get(speedAttribute)).floatValue(), ((Float)mate.entityData.get(speedAttribute)).floatValue());
        float highestSpeed = Math.max(((Float)this.entityData.get(speedAttribute)).floatValue(), ((Float)mate.entityData.get(speedAttribute)).floatValue());
        eggBlockEntitySupplier.get().setSpeedAttribute(this.randomUpperLower(lowestSpeed, highestSpeed));
        float lowestDamage = Math.min(((Float)this.entityData.get(damageAttribute)).floatValue(), ((Float)mate.entityData.get(damageAttribute)).floatValue());
        float highestDamage = Math.max(((Float)this.entityData.get(damageAttribute)).floatValue(), ((Float)mate.entityData.get(damageAttribute)).floatValue());
        eggBlockEntitySupplier.get().setDamageAttribute(this.randomUpperLower(lowestDamage, highestDamage));
    }

    public void setHatchedAttributes(DMREggBlockEntity eggBlockEntity) {
        this.entityData.set(healthAttribute, (Object)Float.valueOf((float)eggBlockEntity.getHealthAttribute()));
        this.entityData.set(speedAttribute, (Object)Float.valueOf((float)eggBlockEntity.getSpeedAttribute()));
        this.entityData.set(damageAttribute, (Object)Float.valueOf((float)eggBlockEntity.getDamageAttribute()));
        this.entityData.set(maxScaleAttribute, (Object)Float.valueOf((float)eggBlockEntity.getMaxScaleAttribute()));
    }

    private int upperLower(double value, int lower, int upper) {
        return (int)Math.round(value * ((double)upper - (double)lower) + (double)lower);
    }

    private double randomUpperLower(int lower, int upper) {
        return this.upperLower(Math.random(), lower, upper);
    }

    private double upperLower(double value, double lower, double upper) {
        return value * (upper - lower) + lower;
    }

    private double randomUpperLower(double lower, double upper) {
        return this.upperLower(Math.random(), lower, upper);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putFloat("healthAttribute", ((Float)this.entityData.get(healthAttribute)).floatValue());
        compound.putFloat("speedAttribute", ((Float)this.entityData.get(speedAttribute)).floatValue());
        compound.putFloat("damageAttribute", ((Float)this.entityData.get(damageAttribute)).floatValue());
        compound.putFloat("maxScaleAttribute", ((Float)this.entityData.get(maxScaleAttribute)).floatValue());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(healthAttribute, (Object)Float.valueOf(compound.getFloat("healthAttribute")));
        this.entityData.set(speedAttribute, (Object)Float.valueOf(compound.getFloat("speedAttribute")));
        this.entityData.set(damageAttribute, (Object)Float.valueOf(compound.getFloat("damageAttribute")));
        this.entityData.set(maxScaleAttribute, (Object)Float.valueOf(compound.getFloat("maxScaleAttribute")));
    }
}

