/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.entity.dragon;

import dmr.DragonMounts.config.ServerConfig;
import dmr.DragonMounts.network.packets.DragonAgeSyncPacket;
import dmr.DragonMounts.registry.DragonBreedsRegistry;
import dmr.DragonMounts.registry.ModBlocks;
import dmr.DragonMounts.registry.ModEntities;
import dmr.DragonMounts.server.blockentities.DMREggBlockEntity;
import dmr.DragonMounts.server.blocks.DMREggBlock;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import dmr.DragonMounts.server.entity.dragon.DragonBreedComponent;
import dmr.DragonMounts.types.dragonBreeds.IDragonBreed;
import dmr.DragonMounts.util.BreedingUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

abstract class DragonBreedableComponent
extends DragonBreedComponent {
    protected DragonBreedableComponent(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    public boolean canMate(Animal mate) {
        if (mate == this) {
            return false;
        }
        if (!(mate instanceof TameableDragonEntity)) {
            return false;
        }
        if (!this.canReproduce()) {
            return false;
        }
        TameableDragonEntity dragonMate = (TameableDragonEntity)mate;
        if (!dragonMate.isTame()) {
            return false;
        }
        if (!dragonMate.canReproduce()) {
            return false;
        }
        return this.isInLove() && dragonMate.isInLove();
    }

    public void spawnChildFromBreeding(ServerLevel level, Animal animal) {
        if (!(animal instanceof TameableDragonEntity)) {
            return;
        }
        TameableDragonEntity mate = (TameableDragonEntity)animal;
        BlockState state = (BlockState)ModBlocks.DRAGON_EGG_BLOCK.get().defaultBlockState().setValue((Property)DMREggBlock.HATCHING, (Comparable)Boolean.valueOf(true));
        ArrayList<IDragonBreed> eggOutcomes = DragonBreedsRegistry.getEggOutcomes(this.getDragon(), level, mate);
        IDragonBreed offSpringBreed = eggOutcomes.get(this.getRandom().nextInt(eggOutcomes.size()));
        IDragonBreed.Variant variant = !offSpringBreed.getVariants().isEmpty() ? offSpringBreed.getVariants().get(this.getRandom().nextInt(offSpringBreed.getVariants().size())) : null;
        DMREggBlockEntity egg = DMREggBlock.place(level, this.blockPosition(), state, offSpringBreed, variant);
        if (ServerConfig.ENABLE_RANDOM_STATS) {
            this.getDragon().setEggBreedAttributes(mate, () -> egg);
        }
        if (this.hasCustomName() && animal.hasCustomName()) {
            String babyName = BreedingUtils.generateCustomName(this.getDragon(), animal);
            egg.setCustomName((Component)Component.literal((String)babyName));
        }
        this.getDragon().updateOwnerData();
    }

    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob mob) {
        TameableDragonEntity offspring = (TameableDragonEntity)ModEntities.DRAGON_ENTITY.get().create((Level)level);
        offspring.setBreed(this.getBreed());
        return offspring;
    }

    public boolean canReproduce() {
        return this.isTame();
    }

    public boolean isFoodItem(ItemStack stack) {
        FoodProperties food = stack.getItem().getFoodProperties(stack, (LivingEntity)this);
        return food != null && stack.is(ItemTags.MEAT);
    }

    public void setAge(int pAge) {
        super.setAge(pAge);
        if (!this.level().isClientSide) {
            PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new DragonAgeSyncPacket(this.getId(), pAge), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.updateAgeProperties();
    }

    @Override
    public void updateAgeProperties() {
        this.refreshDimensions();
        this.getDragon().updateAgeAttributes();
    }

    public float getAgeProgress() {
        float growth = -(this.getDragon().getBreed().getGrowthTime() * 20);
        float min = Math.min(this.getAge(), 0) * 20;
        float ageProgress = 1.0f - min / growth;
        return Mth.clamp((float)ageProgress, (float)0.0f, (float)1.0f);
    }

    public boolean isAdult() {
        return this.getAgeProgress() >= 1.0f;
    }

    public boolean isBaby() {
        return !this.isAdult();
    }

    public boolean isJuvenile() {
        return this.getAgeProgress() >= 0.5f && this.getAgeProgress() < 1.0f;
    }

    public boolean isHatchling() {
        return this.getAgeProgress() < 0.5f;
    }

    public void setBaby(boolean baby) {
        this.setAge(baby ? -this.getDragon().getBreed().getGrowthTime() : 0);
        this.updateAgeProperties();
    }

    public float getScale() {
        float scale = this.getBreed() != null ? this.getBreed().getSizeModifier() : 1.0f;
        return scale * (this.isBaby() ? 0.5f : 1.0f);
    }

    public boolean isFood(ItemStack stack) {
        List<Item> list = this.getBreed().getBreedingItems();
        return !stack.isEmpty() && (list != null && !list.isEmpty() ? list.contains(stack.getItem()) : stack.is(ItemTags.FISHES));
    }

    public void setInLove(@Nullable Player player) {
        super.setInLove(player);
        this.getDragon().stopSitting();
        this.getDragon().setWanderTarget((Optional)Optional.of(GlobalPos.of((ResourceKey)this.level.dimension(), (BlockPos)this.blockPosition())));
    }
}

