/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.server.entity.dragon;

import dmr.DragonMounts.registry.ModMemoryModuleTypes;
import dmr.DragonMounts.server.ai.DragonBodyController;
import dmr.DragonMounts.server.ai.DragonMoveController;
import dmr.DragonMounts.server.ai.navigation.DragonPathNavigation;
import dmr.DragonMounts.server.entity.dragon.DragonInventoryComponent;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;

abstract class DragonMovementComponent
extends DragonInventoryComponent {
    protected boolean isFlying = false;
    private static final int GROUND_CLEARENCE_THRESHOLD = 1;

    protected DragonMovementComponent(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new DragonMoveController(this.getDragon());
    }

    protected PathNavigation createNavigation(Level level) {
        DragonPathNavigation dragonNavigation = new DragonPathNavigation((Mob)this, level);
        dragonNavigation.setCanFloat(true);
        return dragonNavigation;
    }

    public BodyRotationControl createBodyControl() {
        return new DragonBodyController((Mob)this);
    }

    public void setFlying(boolean flying) {
        this.isFlying = flying;
    }

    public float getFlyingSpeed() {
        return (this.isSprinting() ? 1.25f : 1.0f) * (float)this.getAttributeValue(Attributes.FLYING_SPEED);
    }

    public float getSpeed() {
        return (this.isSprinting() ? 1.25f : 1.0f) * (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED);
    }

    public boolean canFly() {
        return !this.isHatchling() && this.getEyeInFluidType().isAir();
    }

    public void liftOff() {
        if (this.canFly()) {
            this.jumpFromGround();
        }
    }

    public boolean shouldFly() {
        if (!this.canFly()) {
            return false;
        }
        if (this.isFlying()) {
            return !this.onGround();
        }
        return this.canFly() && !this.isInWater() && !this.isNearGround() && !this.jumping;
    }

    public boolean isNearGround() {
        EntityDimensions dimensions = this.getDimensions(this.getPose());
        return this.onGround() || !this.level().noCollision((Entity)this, new AABB(this.getX() - (double)(dimensions.width() / 2.0f), this.getY(), this.getZ() - (double)(dimensions.width() / 2.0f), this.getX() + (double)(dimensions.width() / 2.0f), this.getY() - (double)(1.0f * this.getScale()), this.getZ() + (double)(dimensions.width() / 2.0f)));
    }

    @Override
    public void tick() {
        super.tick();
        boolean flying = this.shouldFly();
        if (flying != this.isFlying()) {
            this.setFlying(flying);
        }
        if (this.isNoGravity() != this.shouldFly() && !this.isInWater()) {
            this.setNoGravity(this.shouldFly());
        }
        if (this.getControllingPassenger() == null && !this.getDragon().hasWanderTarget() && !this.isOrderedToSit()) {
            if (this.isPathFinding()) {
                BlockPos dest = this.getNavigation().getTargetPos();
                boolean farDist = (double)dest.distManhattan((Vec3i)this.blockPosition()) >= 16.0;
                this.setSprinting(farDist);
            } else if (this.isSprinting()) {
                this.setSprinting(false);
            }
        }
        if (this.isPathFinding() && this.getNavigation().getPath() != null) {
            PathType type = this.getNavigation().getPath().getNextNode().type;
            if (type == PathType.WALKABLE) {
                this.setFlying(false);
            } else if (type == PathType.WATER || type == PathType.WATER_BORDER) {
                this.setFlying(false);
                this.setSwimming(true);
            }
        }
    }

    public void aiStep() {
        super.aiStep();
        if (this.getControllingPassenger() == null && !this.getDragon().hasWanderTarget() && !this.isOrderedToSit()) {
            if (this.isPathFinding()) {
                BlockPos dest = this.getNavigation().getTargetPos();
                boolean farDist = (double)dest.distManhattan((Vec3i)this.blockPosition()) >= 16.0;
                this.setSprinting(farDist);
            } else if (this.isSprinting()) {
                this.setSprinting(false);
            }
        }
    }

    public boolean isAffectedByFluids() {
        return this.canDrownInFluidType(Fluids.WATER.getFluidType());
    }

    protected float getWaterSlowDown() {
        return 0.5f;
    }

    public boolean canDrownInFluidType(FluidType type) {
        if (type == Fluids.WATER.getFluidType() && this.getBreed() != null && this.getBreed().getImmunities().contains("drown")) {
            return false;
        }
        return super.canDrownInFluidType(type);
    }

    public float getPathfindingMalus(PathType pathType) {
        float originalMalus = super.getPathfindingMalus(pathType);
        if (pathType == PathType.WATER) {
            return this.canDrownInFluidType((FluidType)NeoForgeMod.WATER_TYPE.getDelegate().value()) ? originalMalus : originalMalus * 2.0f;
        }
        if (pathType == PathType.OPEN) {
            return originalMalus * 16.0f;
        }
        return originalMalus;
    }

    public boolean onClimbable() {
        return false;
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader level) {
        return 0.0f;
    }

    public void refreshDimensions() {
        double posXTmp = this.getX();
        double posYTmp = this.getY();
        double posZTmp = this.getZ();
        boolean onGroundTmp = this.onGround();
        super.refreshDimensions();
        this.setPos(posXTmp, posYTmp, posZTmp);
        this.setOnGround(onGroundTmp);
    }

    protected void onChangedBlock(ServerLevel level, BlockPos pos) {
        super.onChangedBlock(level, pos);
        this.getBreed().onMove(this.getDragon());
        this.getBrain().eraseMemory(ModMemoryModuleTypes.IDLE_TICKS.get());
    }

    @Generated
    public boolean isFlying() {
        return this.isFlying;
    }
}

