/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.types.habitats;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dmr.DragonMounts.types.habitats.Habitat;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;

public record LightHabitat(int points, boolean below, int light) implements Habitat
{
    public static final Codec<LightHabitat> CODEC = RecordCodecBuilder.create(func -> func.group(Habitat.withPoints(3, LightHabitat::points), (App)Codec.BOOL.optionalFieldOf("below", (Object)false).forGetter(LightHabitat::below), (App)Codec.INT.fieldOf("light").forGetter(LightHabitat::light)).apply((Applicative)func, LightHabitat::new));

    @Override
    public int getHabitatPoints(Level level, BlockPos pos) {
        int lightEmission = level.getBrightness(LightLayer.BLOCK, pos);
        return (this.below ? lightEmission < this.light : lightEmission > this.light) ? this.points : 0;
    }

    @Override
    public String type() {
        return Habitat.LIGHT;
    }
}

