/*
 * Decompiled with CFR 0.152.
 */
package space.ranzeplay.geologin;

import java.util.ArrayList;
import space.ranzeplay.geologin.GeoLogin;

public class Config {
    public boolean useWhitelist = false;
    public ArrayList<String> countries = new ArrayList();
    public int cacheExpireMinutes = 60;
    public ArrayList<String> ipWhitelist = new ArrayList();
    public boolean allowJoinWhenGeoFail = true;
    public boolean allowPrivateAddress = true;
    public boolean allowLocalAddress = true;

    public boolean isInWhitelist(String ip) {
        if (this.allowLocalAddress && (ip.matches("^127(\\.\\d{1,3}){3}$") || ip.matches("^localhost$"))) {
            GeoLogin.LOGGER.info("Ip is in local address range");
            return true;
        }
        if (this.allowPrivateAddress && (ip.matches("^10(\\.\\d{1,3}){3}$") || ip.matches("^172\\.(1[6-9]|2[0-9]|3[0-1])(\\.\\d{1,3}){2}$") || ip.matches("^192\\.168(\\.\\d{1,3}){2}$"))) {
            GeoLogin.LOGGER.info("Ip is in private address range");
            return true;
        }
        String[] addressItems = ip.split("-");
        block0: for (String ipEntry : this.ipWhitelist) {
            if (ipEntry.contains("-")) {
                String[] segItems = ipEntry.split("-");
                String begin = segItems[0];
                String[] beginAddrItems = begin.split("\\.");
                String end = segItems[1];
                String[] endAddrItems = end.split("\\.");
                for (int i = 0; i < addressItems.length; ++i) {
                    int addrItemInt = Integer.parseInt(addressItems[i]);
                    int beginInt = Integer.parseInt(beginAddrItems[i]);
                    int endInt = Integer.parseInt(endAddrItems[i]);
                    if (addrItemInt < beginInt || addrItemInt > endInt) continue block0;
                }
                return true;
            }
            String[] addr = ipEntry.split("-");
            for (int i = 0; i < addressItems.length; ++i) {
                if (!"*".equals(addr[i]) && !addr[i].equals(addressItems[i])) continue block0;
            }
            return true;
        }
        return false;
    }
}

