/*
 * Decompiled with CFR 0.152.
 */
package space.ranzeplay.geologin;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import space.ranzeplay.geologin.Config;

public class GeoLogin
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"GeoLogin");
    public static Config CONFIG = new Config();
    public static Cache<String, String> CACHE;

    public void onInitialize() {
        Path configPath = FabricLoader.getInstance().getConfigDir();
        Path configFile = configPath.resolve("geologin.json");
        if (!Files.exists(configFile, new LinkOption[0])) {
            try {
                Files.createFile(configFile, new FileAttribute[0]);
                Files.write(configFile, new GsonBuilder().setPrettyPrinting().create().toJson((Object)CONFIG).getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            String config = Files.readString(configFile);
            CONFIG = (Config)new Gson().fromJson(config, Config.class);
            CACHE = CacheBuilder.newBuilder().maximumSize(500L).expireAfterWrite((long)GeoLogin.CONFIG.cacheExpireMinutes, TimeUnit.MINUTES).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LOGGER.info("GeoLogin initialized");
    }
}

