/*
 * Decompiled with CFR 0.152.
 */
package space.ranzeplay.geologin.mixin;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_8792;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import space.ranzeplay.geologin.GeoLogin;

@Mixin(value={class_3324.class})
public class PlayerJoinMixin {
    @Inject(at={@At(value="TAIL")}, method={"onPlayerConnect"})
    private void playerConnect(class_2535 connection, class_3222 player, class_8792 clientData, CallbackInfo ci) {
        boolean isAccept;
        String ipString = connection.method_52909(true);
        String ip = ipString.substring(1, ipString.lastIndexOf(":"));
        GeoLogin.LOGGER.info("Player {} connected from {}", (Object)player.method_5477().getString(), (Object)ip);
        if (GeoLogin.CONFIG.isInWhitelist(ip)) {
            GeoLogin.LOGGER.info("Address of player {} is in IP whitelist", (Object)player.method_5477().getString());
            return;
        }
        String countryCode = (String)GeoLogin.CACHE.getIfPresent((Object)ip);
        if (countryCode != null) {
            GeoLogin.LOGGER.info("Cache hit for IP: {}", (Object)ip);
        } else {
            try {
                HttpClient client = HttpClient.newHttpClient();
                HttpRequest request = HttpRequest.newBuilder().uri(new URI("https://api.iplocation.net/?ip=" + ip)).build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                JsonObject jsonResponse = JsonParser.parseString((String)response.body()).getAsJsonObject();
                countryCode = jsonResponse.get("country_code2").getAsString();
                GeoLogin.CACHE.put((Object)ip, (Object)countryCode);
                GeoLogin.LOGGER.debug("IP Location Data: {}", (Object)jsonResponse);
            }
            catch (Exception e) {
                GeoLogin.LOGGER.error("Failed to get IP location data", (Throwable)e);
                if (GeoLogin.CONFIG.allowJoinWhenGeoFail) {
                    GeoLogin.LOGGER.info("Allowing player {} to join due to GeoIP failure", (Object)player.method_5477().getString());
                    return;
                }
                connection.method_10747((class_2561)class_2561.method_43471((String)"multiplayer.disconnect.authservers_down"));
                GeoLogin.LOGGER.info("Player {} was kicked due to GeoIP failure", (Object)player.method_5477().getString());
                return;
            }
        }
        if (GeoLogin.CONFIG.useWhitelist) {
            isAccept = GeoLogin.CONFIG.countries.contains(countryCode);
        } else {
            boolean bl = isAccept = !GeoLogin.CONFIG.countries.contains(countryCode);
        }
        if (!isAccept) {
            connection.method_10747((class_2561)class_2561.method_43469((String)"multiplayer.disconnect.banned_ip.reason", (Object[])new Object[]{"Not in allowed country"}));
            GeoLogin.LOGGER.info("Player {} from {} was kicked by GeoLogin policy", (Object)player.method_5477().getString(), (Object)countryCode);
        }
    }
}

