package com.daqem.jobsplustools.item;

import com.daqem.jobsplustools.item.breaker.ConnectedBlockBreaker;
import com.daqem.jobsplustools.item.mode.IMode;
import com.daqem.jobsplustools.item.mode.breaker.connected.ConnectBlockBreakerModes;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2465;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_9886;

public class HatchetItem extends class_1743 implements ConnectedBlockBreaker {

    public HatchetItem(class_9886 toolMaterial, float f, float g, class_1793 properties) {
        super(toolMaterial, f, g, properties);
    }

    @Override
    public @NotNull class_1269 method_7836(@NotNull class_1937 level, @NotNull class_1657 player, @NotNull class_1268 hand) {
        if (player.method_5715() && player instanceof class_3222 serverPlayer) switchMode(serverPlayer, player.method_5998(hand));
        return super.method_7836(level, player, hand);
    }

    @Override
    public List<IMode> getAvailableModes() {
        return List.of(ConnectBlockBreakerModes.values());
    }

    @Override
    public void method_67187(class_1799 itemStack, class_9635 tooltipContext, class_10712 tooltipDisplay, Consumer<class_2561> consumer, class_1836 tooltipFlag) {
        super.method_67187(itemStack, tooltipContext, tooltipDisplay, consumer, tooltipFlag);
        getModesTooltip(itemStack).forEach(consumer);
    }

    @Override
    public boolean isValidBlock(class_1799 stack, class_2680 blockState) {
        return this.method_58405(stack, blockState) && blockState.method_26204() instanceof class_2465;
    }
}
