package com.daqem.jobsplustools.item.replacer;

import com.daqem.jobsplustools.item.breaker.BlockBreaker;
import com.daqem.jobsplustools.item.replacer.result.ReplaceableResult;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3222;

public interface BlockReplacer extends BlockBreaker {

    void replaceBlocks(class_3222 player, class_1937 level, class_2338 pos);

    default void replaceBlock(class_3222 player, class_2338 pos, class_1937 level, class_2680 blockState) {
        ReplaceableResult result = isReplaceable(blockState);
        class_2248 block = blockState.method_26204();

        if (result.shouldBreak()) {
            breakBlock(player, pos, level);
        }

        if (result.shouldPlace()) {
            level.method_8652(pos, block.method_9564(), 3);
        }
    }

    default ReplaceableResult isReplaceable(class_2680 state) {
        return ReplaceableResult.breakAndPlace();
    }
}
