package com.daqem.jobsplustools.mixin;

import com.daqem.jobsplustools.item.breaker.BlockBreaker;
import com.daqem.jobsplustools.item.breaker.ConnectedBlockBreaker;
import com.daqem.jobsplustools.item.breaker.MultiBlockBreaker;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2680;
import net.minecraft.class_2945;
import net.minecraft.class_3965;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1657.class)
public class MixinPlayer {

    @Inject(at = @At("RETURN"), method = "getDestroySpeed", cancellable = true)
    public void getDestroySpeed(class_2680 blockState, CallbackInfoReturnable<Float> cir) {
        class_1657 player = (class_1657) (Object) this;
        class_1799 itemStack = player.method_6047();
        if (itemStack.method_7951(blockState)) {
            if (itemStack.method_7909() instanceof MultiBlockBreaker multiBlockBreaker) {
                float returnValue = cir.getReturnValue();
                int blocksToMine = multiBlockBreaker.getBlocksToMine(player, player.method_37908()).size();
                float speedMultiplier = multiBlockBreaker.getActiveMode(itemStack).getSpeedMultiplier(blocksToMine);
                returnValue *= speedMultiplier;
                cir.setReturnValue(returnValue);
            }
            if (itemStack.method_7909() instanceof ConnectedBlockBreaker connectedBlockBreaker) {
                float returnValue = cir.getReturnValue();
                class_3965 blockHitResult = connectedBlockBreaker.getBlockHitResult(player, player.method_37908());
                int blocksToMine = connectedBlockBreaker.getBlocksToMine(player.method_37908(), blockHitResult.method_17777(), itemStack, blockState).size();
                float speedMultiplier = connectedBlockBreaker.getActiveMode(itemStack).getSpeedMultiplier(blocksToMine);
                returnValue *= speedMultiplier;
                cir.setReturnValue(returnValue);
            }
        }
    }

    @Inject(at = @At("TAIL"), method = "defineSynchedData")
    public void defineSyncedData(class_2945.class_9222 builder, CallbackInfo ci) {
        builder.method_56912(BlockBreaker.BREAKER, false);
    }
}
