package com.daqem.jobsplustools.component;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ModeItemComponent(int mode) {

    public static final Codec<ModeItemComponent> CODEC = Codec.lazyInitialized(() ->
            RecordCodecBuilder.create(instance -> instance.group(
                    Codec.INT.fieldOf("mobName").forGetter(ModeItemComponent::mode)
            ).apply(instance, ModeItemComponent::new))
    );

    public static final class_9139<class_9129, ModeItemComponent> STREAM_CODEC = new class_9139<>() {
        @Override
        public @NotNull ModeItemComponent decode(class_9129 buf) {
            return new ModeItemComponent(buf.readInt());
        }

        @Override
        public void encode(class_9129 buf, @Nullable ModeItemComponent packet) {
            buf.method_53002(packet.mode());
        }
    };
}
