package com.daqem.jobsplustools.item;

import com.daqem.jobsplustools.item.mode.IMode;
import com.daqem.jobsplustools.item.replacer.BlockReplacer;
import com.daqem.jobsplustools.item.replacer.MultiBlockReplacer;
import com.daqem.jobsplustools.item.replacer.result.ReplaceableResult;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2302;
import net.minecraft.class_2421;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_9886;

public class HarvesterItem extends class_1794 implements MultiBlockReplacer {

    private final class_9886 toolMaterial;

    public HarvesterItem(class_9886 toolMaterial, float f, float g, class_1793 properties) {
        super(toolMaterial, f, g, properties);
        this.toolMaterial = toolMaterial;
    }

    @Override
    public @NotNull class_1269 method_7836(@NotNull class_1937 level, @NotNull class_1657 player, @NotNull class_1268 hand) {
        if (player instanceof class_3222 serverPlayer) {
            if (player.method_5715()) {
                switchMode(serverPlayer, player.method_5998(hand));
            } else {
                if (hand == class_1268.field_5808) {
                    class_1799 itemStack = player.method_6047();
                    if (itemStack.method_7909() instanceof BlockReplacer blockReplacer) {
                        class_3965 blockHitResult = getBlockHitResult(player, level);
                        blockReplacer.replaceBlocks(serverPlayer, player.method_73183(), blockHitResult.method_17777());
                    }
                }
            }
        }
        return super.method_7836(level, player, hand);
    }

    @Override
    public List<IMode> getAvailableModes() {
        return MultiBlockReplacer.generateAvailableModes(toolMaterial);
    }

    @Override
    public ReplaceableResult isReplaceable(class_2680 state) {
        if (state.method_26204() instanceof class_2302 cropBlock && cropBlock.method_9825(state)) {
            return ReplaceableResult.breakAndPlace();
        }
        else if (state.method_26204() instanceof class_2421 && state.method_11654(class_2421.field_11306) == class_2421.field_31199) {
            return ReplaceableResult.breakAndPlace();
        }
        else {
            return ReplaceableResult.none();
        }
    }

    @Override
    public void method_67187(class_1799 itemStack, class_9635 tooltipContext, class_10712 tooltipDisplay, Consumer<class_2561> consumer, class_1836 tooltipFlag) {
        super.method_67187(itemStack, tooltipContext, tooltipDisplay, consumer, tooltipFlag);
        getModesTooltip(itemStack).forEach(consumer);
    }
}
