package com.daqem.jobsplustools.item.breaker;

import com.daqem.jobsplustools.item.mode.IMode;
import com.daqem.jobsplustools.item.mode.ModeItem;
import com.daqem.jobsplustools.item.mode.breaker.multi.MultiBlockBreakerMode;
import com.daqem.jobsplustools.item.mode.breaker.multi.MultiBlockBreakerModes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_9886;

public interface MultiBlockBreaker extends ModeItem, BlockBreaker {

    @Override
    default void breakBlocks(class_3222 player, class_1937 level, class_2338 pos, class_2680 state) {
        if (player.method_5715()) return;

        getBlocksToMine(player, level).forEach(blockPos ->
                breakBlock(player, blockPos, level));
    }

    default List<class_2338> getBlocksToMine(class_1657 player, class_1937 level) {
        if (player.method_5715()) return new ArrayList<>();

        MultiBlockBreakerMode mode = (MultiBlockBreakerMode) getActiveMode(player.method_6047());
        int rangeX = mode.getRangeX() / 2;
        int rangeY = mode.getRangeY() / 2;
        int rangeZ = mode.getRangeZ() / 2;

        class_3965 blockHitResult = getBlockHitResult(player, level);
        if (blockHitResult.method_17783() != class_3965.Type.field_1332) return new ArrayList<>();

        class_2350.class_2351 axis = blockHitResult.method_17780().method_10166();
        int[] adjustedRanges = adjustRanges(axis, rangeX, rangeY, rangeZ);

        return getBlocksInRange(player, level, blockHitResult.method_17777(), adjustedRanges[0], adjustedRanges[1], adjustedRanges[2]);
    }

    default List<class_2338> getBlocksInRange(class_1657 player, class_1937 level, class_2338 pos, int rangeX, int rangeY, int rangeZ) {
        List<class_2338> blocks = new ArrayList<>();
        for (int x = -rangeX; x <= rangeX; x++) {
            for (int y = -rangeY; y <= rangeY; y++) {
                for (int z = -rangeZ; z <= rangeZ; z++) {
                    class_2338 offset = pos.method_10069(x, y, z);
                    class_2680 blockState = level.method_8320(offset);
                    if (player.method_6047().method_7951(blockState)) {
                        blocks.add(offset);
                    }
                }
            }
        }
        return blocks;
    }

    private int[] adjustRanges(class_2350.class_2351 axis, int rangeX, int rangeY, int rangeZ) {
        if (axis == class_2350.class_2351.field_11052) {
            return new int[]{rangeX, rangeZ, rangeY};
        } else if (axis == class_2350.class_2351.field_11048) {
            return new int[]{rangeZ, rangeY, rangeX};
        } else {
            return new int[]{rangeX, rangeY, rangeZ};
        }
    }

    static List<IMode> generateAvailableModes(class_9886 toolMaterial) {
        if (toolMaterial == class_9886.field_52590) {
            return Arrays.asList(
                    MultiBlockBreakerModes.ONE_BY_ONE,
                    MultiBlockBreakerModes.THREE_BY_THREE,
                    MultiBlockBreakerModes.THREE_BY_THREE_BY_THREE,
                    MultiBlockBreakerModes.FIVE_BY_FIVE,
                    MultiBlockBreakerModes.FIVE_BY_FIVE_BY_FIVE
            );
        } else if (toolMaterial == class_9886.field_52588 || toolMaterial == class_9886.field_52589) {
            return Arrays.asList(
                    MultiBlockBreakerModes.ONE_BY_ONE,
                    MultiBlockBreakerModes.THREE_BY_THREE,
                    MultiBlockBreakerModes.THREE_BY_THREE_BY_THREE,
                    MultiBlockBreakerModes.FIVE_BY_FIVE
            );
        } else if (toolMaterial == class_9886.field_52587) {
            return Arrays.asList(
                    MultiBlockBreakerModes.ONE_BY_ONE,
                    MultiBlockBreakerModes.THREE_BY_THREE,
                    MultiBlockBreakerModes.THREE_BY_THREE_BY_THREE
            );
        } else {
            return Arrays.asList(MultiBlockBreakerModes.ONE_BY_ONE, MultiBlockBreakerModes.THREE_BY_THREE);
        }
    }
}
