package com.daqem.jobsplustools.item.mode;

import com.daqem.jobsplustools.JobsPlusTools;
import com.daqem.jobsplustools.component.ModDataComponentTypes;
import com.daqem.jobsplustools.component.ModeItemComponent;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public interface ModeItem extends class_1935 {

    default @NotNull IMode getActiveMode(class_1799 stack) {
        return ModeItem.ModeItemSerializer.deserialize(stack, this);
    }

    default void setActiveMode(@NotNull class_1799 stack, @NotNull IMode mode) {
        ModeItem.ModeItemSerializer.serialize(stack, mode, this);
    }
    List<IMode> getAvailableModes();

    default IMode getDefaultMode() {
        return getAvailableModes().getFirst();
    }

    default IMode getNextMode(class_1799 stack) {
        List<IMode> availableModes = getAvailableModes();
        int index = availableModes.indexOf(getActiveMode(stack));
        if (index == availableModes.size() - 1) {
            return getDefaultMode();
        }
        return availableModes.get(index + 1);
    }

    default void switchMode(class_3222 player, class_1799 stack) {
        IMode nextMode = getNextMode(stack);
        setActiveMode(stack, nextMode);
        player.method_43502(nextMode.getName().method_27661().method_10862(class_2583.field_24360.method_10977(class_124.field_1060)), true);
    }

    default List<class_2561> getModesTooltip(class_1799 stack) {
        List<IMode> availableModes = getAvailableModes();
        if (availableModes.isEmpty()) return List.of(JobsPlusTools.translatable("tooltip.no_modes").method_27661().method_10862(class_2583.field_24360.method_10977(class_124.field_1080)));
        class_5250 modes = JobsPlusTools.literal("").method_27661();
        for (IMode mode : availableModes) {
            class_5250 component = mode.getName().method_27661();

            if (mode.equals(getActiveMode(stack))) {
                component.method_10862(class_2583.field_24360.method_10977(class_124.field_1060));
            } else {
                component.method_10862(class_2583.field_24360.method_10977(class_124.field_1080));
            }

            if (availableModes.indexOf(mode) != availableModes.size() - 1) {
                component.method_10852(JobsPlusTools.literal(", ").method_27661().method_10862(class_2583.field_24360.method_10977(class_124.field_1080)));
            }
            modes.method_10852(component);
        }
        return List.of(JobsPlusTools.translatable("tooltip.modes", modes).method_27661().method_10862(class_2583.field_24360.method_10977(class_124.field_1080)),
                JobsPlusTools.translatable("tooltip.switch_mode").method_27661().method_10862(class_2583.field_24360.method_10977(class_124.field_1080)));
    }

    class ModeItemSerializer {

        public static void serialize(@NotNull class_1799 stack, IMode mode, ModeItem item) {
            stack.method_57379(ModDataComponentTypes.MODE_ITEM_COMPONENT.get(), new ModeItemComponent(item.getAvailableModes().indexOf(mode)));
        }

        public static IMode deserialize(class_1799 stack, ModeItem item) {
            if (!stack.method_57826(ModDataComponentTypes.MODE_ITEM_COMPONENT.get())) {
                return item.getDefaultMode();
            }
            return item.getAvailableModes().get(stack.method_58694(ModDataComponentTypes.MODE_ITEM_COMPONENT.get()).mode());
        }
    }
}
