package com.daqem.jobsplustools.item.replacer;

import com.daqem.jobsplustools.item.mode.IMode;
import com.daqem.jobsplustools.item.mode.ModeItem;
import com.daqem.jobsplustools.item.mode.replacer.MultiBlockReplacerMode;
import com.daqem.jobsplustools.item.mode.replacer.MultiBlockReplacerModes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.class_9886;

public interface MultiBlockReplacer extends ModeItem, BlockReplacer {

    @Override
    default void replaceBlocks(class_3222 player, class_1937 level, class_2338 pos) {
        if (player.method_5715()) return;

        getBlocksToReplace(player, level, pos).forEach(blockPos ->
                replaceBlock(player, blockPos, level, level.method_8320(blockPos)));
    }

    default List<class_2338> getBlocksToReplace(class_1657 player, class_1937 level, class_2338 pos) {
        if (player.method_5715()) return new ArrayList<>();

        MultiBlockReplacerMode mode = (MultiBlockReplacerMode) getActiveMode(player.method_6047());
        int rangeX = mode.getRangeX() / 2;
        int rangeY = mode.getRangeY() / 2;
        int rangeZ = mode.getRangeZ() / 2;

        return getBlocksInRange(player, level, pos, rangeX, rangeY, rangeZ);
    }

    default List<class_2338> getBlocksInRange(class_1657 player, class_1937 level, class_2338 pos, int rangeX, int rangeY, int rangeZ) {
        List<class_2338> blocks = new ArrayList<>();
        for (int x = -rangeX; x <= rangeX; x++) {
            for (int y = -rangeY; y <= rangeY; y++) {
                for (int z = -rangeZ; z <= rangeZ; z++) {
                    blocks.add(pos.method_10069(x, y, z));
                }
            }
        }
        return blocks;
    }

    static List<IMode> generateAvailableModes(class_9886 toolMaterial) {
        if (toolMaterial == class_9886.field_52587 || toolMaterial == class_9886.field_52589) {
            return Arrays.asList(
                    MultiBlockReplacerModes.ONE_BY_ONE,
                    MultiBlockReplacerModes.THREE_BY_THREE
            );
        } else if (toolMaterial == class_9886.field_52588 || toolMaterial == class_9886.field_52590) {
            return Arrays.asList(
                    MultiBlockReplacerModes.ONE_BY_ONE,
                    MultiBlockReplacerModes.THREE_BY_THREE,
                    MultiBlockReplacerModes.FIVE_BY_FIVE
            );
        } else {
            return List.of(MultiBlockReplacerModes.ONE_BY_ONE);
        }
    }
}
