/*
 * Decompiled with CFR 0.152.
 */
package btw.lowercase.skyboxify;

import btw.lowercase.skyboxify.config.SkyboxifyConfig;
import btw.lowercase.skyboxify.events.LevelTickEvent;
import btw.lowercase.skyboxify.events.SkyRenderEvent;
import btw.lowercase.skyboxify.skybox.Skybox;
import btw.lowercase.skyboxify.skybox.SkyboxManager;
import btw.lowercase.skyboxify.skybox.SkyboxSkyRenderer;
import com.mojang.blaze3d.systems.RenderSystem;
import lombok.Generated;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.visuals.legacy.lightconfig.lib.v1.events.EventManager;

public final class Skyboxify {
    public static final String MOD_ID = "skyboxify";
    private static final Logger logger = LoggerFactory.getLogger(Skyboxify.class);
    private static final EventManager eventManager = new EventManager();
    private static final SkyboxifyConfig config = new SkyboxifyConfig();

    public static class_2960 locationOrNull(String path) {
        return class_2960.method_43902((String)MOD_ID, (String)path);
    }

    public static void initialize() {
        config.load();
        eventManager.listen(LevelTickEvent.Client.class, event -> SkyboxManager.INSTANCE.tick(event.getLevel()));
        eventManager.listen(SkyRenderEvent.Celestial.class, event -> {
            if (Skyboxify.getConfig().enabled.isEnabled()) {
                SkyRenderEvent.Celestial.Type type = event.getType();
                if (!(Skyboxify.config.renderSunMoon.isEnabled() || type != SkyRenderEvent.Celestial.Type.SUN && type != SkyRenderEvent.Celestial.Type.MOON)) {
                    event.setCancelled(true);
                } else if (!Skyboxify.config.renderStars.isEnabled() && type == SkyRenderEvent.Celestial.Type.STARS) {
                    event.setCancelled(true);
                }
            }
        });
        eventManager.listen(SkyRenderEvent.SunriseSunset.After.class, event -> {
            if (SkyboxManager.INSTANCE.isEnabled(event.getLevel())) {
                event.getBufferSource().method_22993();
            }
        });
        eventManager.listen(SkyRenderEvent.EndSky.After.class, event -> Skyboxify.renderSkyboxes(event.getLevel(), 0.0f));
        eventManager.listen(SkyRenderEvent.SunMoonStars.class, event -> {
            class_638 clientLevel = event.getLevel();
            Skyboxify.renderSkyboxes(clientLevel, event.getTickDelta());
            if (SkyboxManager.INSTANCE.isEnabled((class_1937)clientLevel) && SkyboxManager.INSTANCE.containsEnabled((class_5321<class_1937>)class_1937.field_25180) && clientLevel.method_27983().equals(class_1937.field_25180)) {
                event.setCancelled(true);
            }
        });
    }

    private static void renderSkyboxes(class_638 clientLevel, float tickDelta) {
        if (SkyboxManager.INSTANCE.isEnabled((class_1937)clientLevel)) {
            Matrix4f modelViewMatrix = new Matrix4f((Matrix4fc)RenderSystem.getModelViewStack()).rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(-90.0f));
            for (Skybox skybox : SkyboxManager.INSTANCE.getActiveSkyboxes()) {
                SkyboxSkyRenderer.INSTANCE.renderSkybox(skybox, modelViewMatrix, clientLevel, tickDelta);
            }
        }
    }

    @Generated
    private Skyboxify() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @Generated
    public static Logger getLogger() {
        return logger;
    }

    @Generated
    public static EventManager getEventManager() {
        return eventManager;
    }

    @Generated
    public static SkyboxifyConfig getConfig() {
        return config;
    }
}

