/*
 * Decompiled with CFR 0.152.
 */
package btw.lowercase.skyboxify.skybox;

import btw.lowercase.skyboxify.Skyboxify;
import btw.lowercase.skyboxify.skybox.SkyLayer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.minecraft.class_1937;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;

public class Skybox {
    public static final Codec<Skybox> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("pack").forGetter(Skybox::getPackName), (App)class_1937.field_25178.fieldOf("world").forGetter(Skybox::getWorldKey), (App)SkyLayer.CODEC.listOf().fieldOf("layers").forGetter(Skybox::getLayers)).apply((Applicative)instance, Skybox::new));
    private final String packName;
    private final List<SkyLayer> layers;
    private final class_5321<@NotNull class_1937> worldKey;
    private final Map<SkyLayer, Float> alphaMap = new HashMap<SkyLayer, Float>();
    private boolean active = true;

    public Skybox(String packName, class_5321<@NotNull class_1937> worldKey, List<SkyLayer> layers) {
        this.packName = packName;
        this.worldKey = worldKey;
        this.layers = layers;
    }

    public void tick(class_638 level) {
        boolean allowOtherDimensions;
        this.active = true;
        boolean bl = allowOtherDimensions = Skyboxify.getConfig().showOverworldForUnknownDimension.isEnabled() && this.worldKey.equals((Object)class_1937.field_25179) && !level.method_27983().equals(class_1937.field_25180) && !level.method_27983().equals(class_1937.field_25181);
        if (level.method_27983().equals(this.worldKey) || allowOtherDimensions) {
            this.layers.forEach(layer -> this.alphaMap.put((SkyLayer)layer, Float.valueOf(layer.getPositionBrightness((class_1937)level, this.getConditionAlphaFor((SkyLayer)layer)))));
        } else {
            this.layers.forEach(layer -> this.alphaMap.put((SkyLayer)layer, Float.valueOf(-1.0f)));
            this.active = false;
        }
    }

    public float getConditionAlphaFor(SkyLayer skyLayer) {
        return this.alphaMap.getOrDefault(skyLayer, Float.valueOf(-1.0f)).floatValue();
    }

    @Generated
    public String getPackName() {
        return this.packName;
    }

    @Generated
    public List<SkyLayer> getLayers() {
        return this.layers;
    }

    @Generated
    public class_5321<@NotNull class_1937> getWorldKey() {
        return this.worldKey;
    }

    @Generated
    public boolean isActive() {
        return this.active;
    }
}

