/*
 * Decompiled with CFR 0.152.
 */
package btw.lowercase.skyboxify.utils;

import btw.lowercase.skyboxify.skybox.components.Range;
import btw.lowercase.skyboxify.skybox.components.Weather;
import java.util.List;
import lombok.Generated;
import net.minecraft.class_3532;

public final class CommonUtils {
    public static int normalizeTickTime(int tickTime) {
        int result = tickTime % 24000;
        if (result < 0) {
            result += 24000;
        }
        return result;
    }

    public static boolean checkRanges(double value, List<Range> rangeEntries) {
        return rangeEntries.isEmpty() || rangeEntries.stream().anyMatch(range -> com.google.common.collect.Range.closed((Comparable)Float.valueOf(range.min()), (Comparable)Float.valueOf(range.max())).contains((Comparable)Float.valueOf((float)value)));
    }

    public static boolean isInTimeInterval(int currentTime, int startTime, int endTime) {
        if (currentTime < 0 || currentTime >= 24000) {
            return false;
        }
        if (startTime <= endTime) {
            return currentTime >= startTime && currentTime <= endTime;
        }
        return currentTime >= startTime || currentTime <= endTime;
    }

    public static float calculateFadeAlphaValue(float maxAlpha, float minAlpha, int currentTime, int startFadeIn, int endFadeIn, int startFadeOut, int endFadeOut) {
        if (CommonUtils.isInTimeInterval(currentTime, endFadeIn, startFadeOut)) {
            return maxAlpha;
        }
        if (CommonUtils.isInTimeInterval(currentTime, startFadeIn, endFadeIn)) {
            int fadeInDuration = CommonUtils.calculateCyclicTimeDistance(startFadeIn, endFadeIn);
            int timePassedSinceFadeInStart = CommonUtils.calculateCyclicTimeDistance(startFadeIn, currentTime);
            return minAlpha + (float)timePassedSinceFadeInStart / (float)fadeInDuration * (maxAlpha - minAlpha);
        }
        if (CommonUtils.isInTimeInterval(currentTime, startFadeOut, endFadeOut)) {
            int fadeOutDuration = CommonUtils.calculateCyclicTimeDistance(startFadeOut, endFadeOut);
            int timePassedSinceFadeOutStart = CommonUtils.calculateCyclicTimeDistance(startFadeOut, currentTime);
            return maxAlpha + (float)timePassedSinceFadeOutStart / (float)fadeOutDuration * (minAlpha - maxAlpha);
        }
        return minAlpha;
    }

    public static int calculateCyclicTimeDistance(int startTime, int endTime) {
        return (endTime - startTime + 24000) % 24000;
    }

    public static float calculateConditionAlphaValue(float maxAlpha, float minAlpha, float lastAlpha, int duration, boolean in) {
        if (duration == 0) {
            return lastAlpha;
        }
        if (in && maxAlpha == lastAlpha) {
            return maxAlpha;
        }
        if (!in && lastAlpha == minAlpha) {
            return minAlpha;
        }
        float alphaChange = (maxAlpha - minAlpha) / (float)duration;
        float result = in ? lastAlpha + alphaChange : lastAlpha - alphaChange;
        return class_3532.method_15363((float)result, (float)minAlpha, (float)maxAlpha);
    }

    public static float getWeatherAlpha(List<Weather> weatherConditions, float rainStrength, float thunderStrength) {
        float alpha = 1.0f - rainStrength;
        float calculatedRainStrength = rainStrength - thunderStrength;
        float weatherAlpha = 0.0f;
        if (weatherConditions.contains((Object)Weather.CLEAR)) {
            weatherAlpha += alpha;
        }
        if (weatherConditions.contains((Object)Weather.RAIN)) {
            weatherAlpha += calculatedRainStrength;
        }
        if (weatherConditions.contains((Object)Weather.THUNDER)) {
            weatherAlpha += thunderStrength;
        }
        return class_3532.method_15363((float)weatherAlpha, (float)0.0f, (float)1.0f);
    }

    @Generated
    private CommonUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

