/*
 * Decompiled with CFR 0.152.
 */
package btw.lowercase.optiboxes.skybox;

import btw.lowercase.optiboxes.skybox.OptiFineSkyLayer;
import btw.lowercase.optiboxes.skybox.OptiFineSkybox;
import btw.lowercase.optiboxes.utils.CommonUtils;
import btw.lowercase.optiboxes.utils.SkyPart;
import btw.lowercase.optiboxes.utils.UVRange;
import btw.lowercase.optiboxes.utils.components.Blend;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1937;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_8555;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

public final class OptiFineSkyRenderer {
    public static final OptiFineSkyRenderer INSTANCE = new OptiFineSkyRenderer();
    private class_291 skyBuffer;

    private OptiFineSkyRenderer() {
        class_310.method_1551().method_63588(this::buildSky);
    }

    private void buildSky() {
        class_293 vertexFormat = class_290.field_1585;
        try (class_9799 byteBufferBuilder = new class_9799(vertexFormat.method_1362() * SkyPart.COUNT * 4);){
            class_293.class_5596 vertexFormatMode = class_293.class_5596.field_27382;
            class_287 builder = new class_287(byteBufferBuilder, vertexFormatMode, vertexFormat);
            for (SkyPart skyPart : SkyPart.VALUES) {
                Matrix4f matrix4f = skyPart.getRotationMatrix();
                UVRange uvRange = skyPart.getUVRange();
                float quadSize = 30.0f;
                builder.method_22918(matrix4f, -30.0f, -30.0f, -30.0f).method_22913(uvRange.minU(), uvRange.minV());
                builder.method_22918(matrix4f, -30.0f, -30.0f, 30.0f).method_22913(uvRange.minU(), uvRange.maxV());
                builder.method_22918(matrix4f, 30.0f, -30.0f, 30.0f).method_22913(uvRange.maxU(), uvRange.maxV());
                builder.method_22918(matrix4f, 30.0f, -30.0f, -30.0f).method_22913(uvRange.maxU(), uvRange.minV());
            }
            try (class_9801 meshData = builder.method_60800();){
                this.skyBuffer = new class_291(class_8555.field_54340);
                this.skyBuffer.method_1353();
                this.skyBuffer.method_1352(meshData);
                class_291.method_1354();
            }
        }
    }

    public void renderSkybox(OptiFineSkybox optiFineSkybox, Matrix4fStack modelViewStack, class_1937 level, float tickDelta) {
        long dayTime = level.method_8532();
        int clampedTimeOfDay = (int)(dayTime % 24000L);
        float skyAngle = level.method_30274(tickDelta);
        float thunderLevel = level.method_8478(tickDelta);
        float rainLevel = level.method_8430(tickDelta);
        if (rainLevel > 0.0f) {
            thunderLevel /= rainLevel;
        }
        for (OptiFineSkyLayer optiFineSkyLayer : optiFineSkybox.getLayers().stream().filter(layer -> layer.isActive(dayTime, clampedTimeOfDay)).toList()) {
            this.renderSkyLayer(optiFineSkyLayer, modelViewStack, level, clampedTimeOfDay, skyAngle, rainLevel, thunderLevel, optiFineSkybox.getConditionAlphaFor(optiFineSkyLayer));
        }
        Blend.ADD.apply(1.0f - rainLevel);
    }

    public void renderSkyLayer(OptiFineSkyLayer optiFineSkyLayer, Matrix4fStack modelViewStack, class_1937 level, int timeOfDay, float skyAngle, float rainGradient, float thunderGradient, float conditionAlpha) {
        float fadeAlpha;
        float weatherAlpha = CommonUtils.getWeatherAlpha(optiFineSkyLayer.weatherConditions(), rainGradient, thunderGradient);
        float finalAlpha = class_3532.method_15363((float)(conditionAlpha * weatherAlpha * (fadeAlpha = optiFineSkyLayer.fade().getAlpha(timeOfDay))), (float)0.0f, (float)1.0f);
        if (!(finalAlpha < 1.0E-4f) && this.skyBuffer != null) {
            modelViewStack.pushMatrix();
            if (optiFineSkyLayer.rotate()) {
                modelViewStack.rotate((Quaternionfc)new Quaternionf(new AxisAngle4f(this.getAngle(level, skyAngle, optiFineSkyLayer.speed()), (Vector3fc)optiFineSkyLayer.axis())));
            }
            RenderSystem.setShaderTexture((int)0, (class_2960)optiFineSkyLayer.source());
            RenderSystem.setShader((class_10156)class_10142.field_53879);
            optiFineSkyLayer.blend().apply(finalAlpha);
            this.skyBuffer.method_1353();
            this.skyBuffer.method_34427((Matrix4f)modelViewStack, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
            class_291.method_1354();
            modelViewStack.popMatrix();
        }
    }

    private float getAngle(class_1937 level, float skyAngle, float speed) {
        float angleDayStart = 0.0f;
        if (speed != (float)Math.round(speed)) {
            long currentWorldDay = (level.method_8532() + 18000L) / 24000L;
            double anglePerDay = speed % 1.0f;
            double currentAngle = (double)currentWorldDay * anglePerDay;
            angleDayStart = (float)(currentAngle % 1.0);
        }
        return (float)Math.toRadians(360.0f * (angleDayStart + skyAngle * speed));
    }

    public void clearCache() {
    }
}

