/*
 * Decompiled with CFR 0.152.
 */
package btw.lowercase.skyboxify;

import btw.lowercase.skyboxify.config.SkyboxifyConfig;
import btw.lowercase.skyboxify.events.LevelTickEvent;
import btw.lowercase.skyboxify.events.SkyRenderEvent;
import btw.lowercase.skyboxify.skybox.Skybox;
import btw.lowercase.skyboxify.skybox.SkyboxManager;
import btw.lowercase.skyboxify.skybox.SkyboxParser;
import btw.lowercase.skyboxify.skybox.SkyboxResourceHelper;
import btw.lowercase.skyboxify.skybox.SkyboxSkyRenderer;
import btw.lowercase.skyboxify.utils.ParserCodecs;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.visuals.legacy.lightconfig.lib.v1.events.EventManager;

public final class Skyboxify {
    public static final String MOD_ID = "skyboxify";
    private static final Logger logger = LoggerFactory.getLogger(Skyboxify.class);
    private static final EventManager eventManager = new EventManager();
    private static final String OPTIFINE_SKY_PARENT = "optifine/sky";
    private static final String SKY_PATTERN_ENDING = "(?<world>[\\w-]+)/(?<name>\\w+).properties$";
    private static final Pattern OPTIFINE_SKY_PATTERN = Pattern.compile("optifine/sky/(?<world>[\\w-]+)/(?<name>\\w+).properties$");
    private static final String MCPATCHER_SKY_PARENT = "mcpatcher/sky";
    private static final Pattern MCPATCHER_SKY_PATTERN = Pattern.compile("mcpatcher/sky/(?<world>[\\w-]+)/(?<name>\\w+).properties$");
    private static SkyboxifyConfig config;

    public static class_2960 locationOrNull(String path) {
        return class_2960.method_43902((String)MOD_ID, (String)path);
    }

    public static void initialize(Path configPath) {
        config = new SkyboxifyConfig(configPath);
        config.load();
        eventManager.listen(LevelTickEvent.Client.class, event -> SkyboxManager.INSTANCE.tick(event.getLevel()));
        eventManager.listen(SkyRenderEvent.Celestial.class, event -> {
            if (Skyboxify.getConfig().enabled.isEnabled()) {
                SkyRenderEvent.Celestial.Type type = event.getType();
                if (!(Skyboxify.config.renderSunMoon.isEnabled() || type != SkyRenderEvent.Celestial.Type.SUN && type != SkyRenderEvent.Celestial.Type.MOON)) {
                    event.setCancelled(true);
                } else if (!Skyboxify.config.renderStars.isEnabled() && type == SkyRenderEvent.Celestial.Type.STARS) {
                    event.setCancelled(true);
                }
            }
        });
        eventManager.listen(SkyRenderEvent.SunriseSunset.After.class, event -> {
            if (SkyboxManager.INSTANCE.isEnabled(event.getLevel())) {
                event.getBufferSource().method_22993();
            }
        });
        eventManager.listen(SkyRenderEvent.EndSky.After.class, event -> Skyboxify.renderSkyboxes(event.getLevel(), 0.0f));
        eventManager.listen(SkyRenderEvent.SunMoonStars.class, event -> {
            class_638 clientLevel = event.getLevel();
            Skyboxify.renderSkyboxes(clientLevel, event.getTickDelta());
            if (SkyboxManager.INSTANCE.isEnabled((class_1937)clientLevel) && SkyboxManager.INSTANCE.containsEnabled((class_5321<class_1937>)class_1937.field_25180) && clientLevel.method_27983().equals(class_1937.field_25180)) {
                event.setCancelled(true);
            }
        });
    }

    private static void renderSkyboxes(class_638 clientLevel, float tickDelta) {
        if (SkyboxManager.INSTANCE.isEnabled((class_1937)clientLevel)) {
            Matrix4f modelViewMatrix = new Matrix4f((Matrix4fc)RenderSystem.getModelViewStack()).rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(-90.0f));
            for (Skybox skybox : SkyboxManager.INSTANCE.getActiveSkyboxes()) {
                SkyboxSkyRenderer.INSTANCE.renderSkybox(skybox, modelViewMatrix, clientLevel, tickDelta);
            }
        }
    }

    public static void convert(SkyboxResourceHelper skyboxResourceHelper) {
        if (Skyboxify.config.processOptiFine.isEnabled()) {
            Skyboxify.parseSkyboxes(skyboxResourceHelper, OPTIFINE_SKY_PARENT, OPTIFINE_SKY_PATTERN);
        }
        if (Skyboxify.config.processMCPatcher.isEnabled()) {
            Skyboxify.parseSkyboxes(skyboxResourceHelper, MCPATCHER_SKY_PARENT, MCPATCHER_SKY_PATTERN);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void parseSkyboxes(SkyboxResourceHelper skyboxResourceHelper, String skyParent, Pattern skyPattern) {
        HashMap<String, JsonArray> layers = new HashMap<String, JsonArray>();
        layers.put("world0", new JsonArray());
        layers.put("world-1", new JsonArray());
        layers.put("world1", new JsonArray());
        skyboxResourceHelper.searchIn(skyParent).filter(id -> id.method_12832().endsWith(".properties")).sorted(Comparator.comparing(class_2960::method_12832, (id1, id2) -> {
            Matcher matcherId1 = skyPattern.matcher((CharSequence)id1);
            Matcher matcherId2 = skyPattern.matcher((CharSequence)id2);
            if (matcherId1.find() && matcherId2.find()) {
                int a = ParserCodecs.safeParseInteger(matcherId1.group("name").replace("sky", ""), -1);
                int b = ParserCodecs.safeParseInteger(matcherId2.group("name").replace("sky", ""), -1);
                if (a >= 0 && b >= 0) {
                    return a - b;
                }
            }
            return 0;
        })).forEach(id -> {
            Matcher matcher = skyPattern.matcher(id.method_12832());
            if (matcher.find()) {
                String world = matcher.group("world");
                String name = matcher.group("name");
                if (world == null || name == null) {
                    return;
                }
                if (name.equals("moon_phases") || name.equals("sun")) {
                    logger.warn("Skipping {}, moon_phases/sun aren't currently supported!", id);
                    return;
                }
                InputStream inputStream = skyboxResourceHelper.getInputStream((class_2960)id);
                if (inputStream == null) {
                    logger.error("Error trying to read namespaced identifier: {}", id);
                    return;
                }
                Properties properties = new Properties();
                try {
                    properties.load(inputStream);
                }
                catch (IOException e) {
                    logger.error("Error trying to read properties from: {}", id);
                    return;
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        logger.error("Error trying to close input stream at namespaced identifier: {}", id);
                    }
                }
                JsonObject json = SkyboxParser.parseSkyProperties(properties, id);
                if (json != null && layers.containsKey(world)) {
                    ((JsonArray)layers.get(world)).add((JsonElement)json);
                }
            }
        });
        for (Map.Entry entry : layers.entrySet()) {
            JsonObject skyJson = new JsonObject();
            JsonArray skyLayers = (JsonArray)entry.getValue();
            if (skyLayers.isEmpty()) continue;
            skyJson.add("layers", (JsonElement)skyLayers);
            @NotNull class_5321 resourceKey = switch ((String)entry.getKey()) {
                case "world-1" -> class_1937.field_25180;
                case "world1" -> class_1937.field_25181;
                default -> class_1937.field_25179;
            };
            skyJson.addProperty("world", resourceKey.method_29177().toString());
            SkyboxManager.INSTANCE.addSkybox((Skybox)((Pair)Skybox.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)skyJson).getOrThrow()).getFirst());
        }
    }

    @Generated
    private Skyboxify() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @Generated
    public static Logger getLogger() {
        return logger;
    }

    @Generated
    public static EventManager getEventManager() {
        return eventManager;
    }

    @Generated
    public static SkyboxifyConfig getConfig() {
        return config;
    }
}

