/*
 * Decompiled with CFR 0.152.
 */
package btw.lowercase.skyboxify.skybox;

import btw.lowercase.skyboxify.Skyboxify;
import btw.lowercase.skyboxify.skybox.SkyLayer;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.minecraft.class_1937;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;

public class Skybox {
    public static final Codec<Skybox> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SkyLayer.CODEC.listOf().optionalFieldOf("layers", (Object)ImmutableList.of()).forGetter(Skybox::getLayers), (App)class_1937.field_25178.fieldOf("world").forGetter(Skybox::getWorldResourceKey)).apply((Applicative)instance, Skybox::new));
    private final List<SkyLayer> layers;
    private final class_5321<@NotNull class_1937> worldResourceKey;
    private final Map<SkyLayer, Float> alphaMap = new HashMap<SkyLayer, Float>();
    private boolean active = true;

    public Skybox(List<SkyLayer> layers, class_5321<@NotNull class_1937> worldResourceKey) {
        this.layers = layers;
        this.worldResourceKey = worldResourceKey;
    }

    public void tick(class_638 level) {
        boolean allowOtherDimensions;
        this.active = true;
        boolean bl = allowOtherDimensions = Skyboxify.getConfig().showOverworldForUnknownDimension.isEnabled() && this.worldResourceKey.equals((Object)class_1937.field_25179) && !level.method_27983().equals(class_1937.field_25180) && !level.method_27983().equals(class_1937.field_25181);
        if (level.method_27983().equals(this.worldResourceKey) || allowOtherDimensions) {
            this.layers.forEach(layer -> this.alphaMap.put((SkyLayer)layer, Float.valueOf(layer.getPositionBrightness((class_1937)level, this.getConditionAlphaFor((SkyLayer)layer)))));
        } else {
            this.layers.forEach(layer -> this.alphaMap.put((SkyLayer)layer, Float.valueOf(-1.0f)));
            this.active = false;
        }
    }

    public float getConditionAlphaFor(SkyLayer skyLayer) {
        return this.alphaMap.getOrDefault(skyLayer, Float.valueOf(-1.0f)).floatValue();
    }

    @Generated
    public List<SkyLayer> getLayers() {
        return this.layers;
    }

    @Generated
    public class_5321<@NotNull class_1937> getWorldResourceKey() {
        return this.worldResourceKey;
    }

    @Generated
    public boolean isActive() {
        return this.active;
    }
}

