/*
 * Decompiled with CFR 0.152.
 */
package btw.lowercase.skyboxify.utils;

import java.util.Optional;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public final class DynamicTransformsBuilder {
    private Optional<Matrix4f> modelViewMatrix = Optional.empty();
    private Optional<Vector4f> colorModulator = Optional.empty();
    private Optional<Vector3f> modelOffset = Optional.empty();
    private Optional<Matrix4f> textureMatrix = Optional.empty();

    public static DynamicTransformsBuilder of() {
        return new DynamicTransformsBuilder();
    }

    public DynamicTransformsBuilder withModelViewMatrix(Matrix4f matrix4f) {
        this.modelViewMatrix = Optional.of(matrix4f);
        return this;
    }

    public DynamicTransformsBuilder withShaderColor(Vector4f vector4f) {
        this.colorModulator = Optional.of(vector4f);
        return this;
    }

    public DynamicTransformsBuilder withShaderColor(Vector3f vector3f) {
        return this.withShaderColor(new Vector4f((Vector3fc)vector3f, 1.0f));
    }

    public DynamicTransformsBuilder withShaderColor(float red, float green, float blue, float alpha) {
        return this.withShaderColor(new Vector4f(red, green, blue, alpha));
    }

    public DynamicTransformsBuilder withShaderColor(float red, float green, float blue) {
        return this.withShaderColor(new Vector3f(red, green, blue));
    }

    public DynamicTransformsBuilder withModelOffset(Vector3f vector3f) {
        this.modelOffset = Optional.of(vector3f);
        return this;
    }

    public DynamicTransformsBuilder withTextureMatrix(Matrix4f matrix4f) {
        this.textureMatrix = Optional.of(matrix4f);
        return this;
    }
}

