/*
 * Decompiled with CFR 0.152.
 */
package btw.lowercase.optiboxes.skybox;

import btw.lowercase.optiboxes.utils.CommonUtils;
import btw.lowercase.optiboxes.utils.components.Blend;
import btw.lowercase.optiboxes.utils.components.Fade;
import btw.lowercase.optiboxes.utils.components.Loop;
import btw.lowercase.optiboxes.utils.components.Range;
import btw.lowercase.optiboxes.utils.components.Weather;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import org.joml.Vector3f;

public record OptiFineSkyLayer(class_2960 source, boolean biomeInclusion, List<class_2960> biomes, List<Range> heights, Blend blend, Fade fade, boolean rotate, float speed, Vector3f axis, Loop loop, float transition, List<Weather> weatherConditions) {
    public static final Codec<OptiFineSkyLayer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("source").forGetter(OptiFineSkyLayer::source), (App)Codec.BOOL.optionalFieldOf("biomeInclusion", (Object)true).forGetter(OptiFineSkyLayer::biomeInclusion), (App)class_2960.field_25139.listOf().optionalFieldOf("biomes", (Object)ImmutableList.of()).forGetter(OptiFineSkyLayer::biomes), (App)Range.CODEC.listOf().optionalFieldOf("heights", (Object)ImmutableList.of()).forGetter(OptiFineSkyLayer::heights), (App)Blend.CODEC.optionalFieldOf("blend", (Object)Blend.ADD).forGetter(OptiFineSkyLayer::blend), (App)Fade.CODEC.optionalFieldOf("fade", (Object)Fade.DEFAULT).forGetter(OptiFineSkyLayer::fade), (App)Codec.BOOL.optionalFieldOf("rotate", (Object)false).forGetter(OptiFineSkyLayer::rotate), (App)Codec.FLOAT.optionalFieldOf("speed", (Object)Float.valueOf(1.0f)).forGetter(OptiFineSkyLayer::speed), (App)class_5699.field_40723.optionalFieldOf("axis", (Object)new Vector3f(1.0f, 0.0f, 0.0f)).forGetter(OptiFineSkyLayer::axis), (App)Loop.CODEC.optionalFieldOf("loop", (Object)Loop.DEFAULT).forGetter(OptiFineSkyLayer::loop), (App)Codec.FLOAT.optionalFieldOf("transition", (Object)Float.valueOf(1.0f)).forGetter(OptiFineSkyLayer::transition), (App)Weather.CODEC.listOf().optionalFieldOf("weather", (Object)ImmutableList.of((Object)((Object)Weather.CLEAR))).forGetter(OptiFineSkyLayer::weatherConditions)).apply((Applicative)instance, OptiFineSkyLayer::new));

    public boolean getConditionCheck(class_1937 level) {
        class_1297 cameraEntity = class_310.method_1551().method_1560();
        if (cameraEntity == null) {
            return false;
        }
        class_2338 entityPos = cameraEntity.method_23312();
        if (!this.biomes.isEmpty()) {
            class_6880 currentBiome = level.method_23753(entityPos);
            if (!currentBiome.method_40227()) {
                return false;
            }
            if (!this.biomeInclusion || !this.biomes.contains(((class_5321)level.method_23753(cameraEntity.method_24515()).method_40230().orElseThrow()).method_29177())) {
                return false;
            }
        }
        return this.heights == null || CommonUtils.checkRanges(entityPos.method_10264(), this.heights);
    }

    public float getPositionBrightness(class_1937 level, float conditionAlpha) {
        if (this.biomes.isEmpty() && this.heights.isEmpty()) {
            return 1.0f;
        }
        if (conditionAlpha == -1.0f) {
            return this.getConditionCheck(level) ? 1.0f : 0.0f;
        }
        return CommonUtils.calculateConditionAlphaValue(1.0f, 0.0f, conditionAlpha, (int)(this.transition * 20.0f), this.getConditionCheck(level));
    }

    public boolean isActive(long dayTime, int clampedTimeOfDay) {
        if (!this.fade.alwaysOn() && CommonUtils.isInTimeInterval(clampedTimeOfDay, this.fade.endFadeOut(), this.fade.startFadeIn())) {
            return false;
        }
        if (this.loop.ranges() != null) {
            long adjustedTime;
            for (adjustedTime = dayTime - (long)this.fade.startFadeIn(); adjustedTime < 0L; adjustedTime += 24000L * (long)((int)this.loop.days())) {
            }
            int daysPassed = (int)(adjustedTime / 24000L);
            int currentDay = daysPassed % (int)this.loop.days();
            return CommonUtils.checkRanges(currentDay, this.loop.ranges());
        }
        return true;
    }
}

