/*
 * Decompiled with CFR 0.152.
 */
package btw.lowercase.optiboxes.skybox;

import btw.lowercase.optiboxes.OptiBoxesClient;
import btw.lowercase.optiboxes.mixins.RenderPipelinesAccessor;
import btw.lowercase.optiboxes.skybox.OptiFineSkyLayer;
import btw.lowercase.optiboxes.skybox.OptiFineSkybox;
import btw.lowercase.optiboxes.utils.BlendFunction;
import btw.lowercase.optiboxes.utils.CommonUtils;
import btw.lowercase.optiboxes.utils.IrisPipeline;
import btw.lowercase.optiboxes.utils.IrisUtil;
import btw.lowercase.optiboxes.utils.SkyPart;
import btw.lowercase.optiboxes.utils.UVRange;
import com.mojang.blaze3d.buffers.BufferType;
import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.class_1044;
import net.minecraft.class_1937;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

public final class OptiFineSkyRenderer {
    public static final OptiFineSkyRenderer INSTANCE = new OptiFineSkyRenderer();
    private GpuBuffer skyBuffer;
    private RenderSystem.class_5590 skyBufferIndices;
    private int skyBufferIndexCount;
    private final Map<class_2960, RenderPipeline> renderPipelineCache = new HashMap<class_2960, RenderPipeline>();

    private OptiFineSkyRenderer() {
        class_310.method_1551().method_63588(this::buildSky);
    }

    private void buildSky() {
        VertexFormat vertexFormat = class_290.field_1585;
        try (class_9799 byteBufferBuilder = new class_9799(vertexFormat.getVertexSize() * SkyPart.COUNT * 4);){
            VertexFormat.class_5596 vertexFormatMode = VertexFormat.class_5596.field_27382;
            class_287 builder = new class_287(byteBufferBuilder, vertexFormatMode, vertexFormat);
            for (SkyPart skyPart : SkyPart.VALUES) {
                Matrix4f matrix4f = skyPart.getRotationMatrix();
                UVRange uvRange = skyPart.getUVRange();
                float quadSize = 30.0f;
                builder.method_22918(matrix4f, -30.0f, -30.0f, -30.0f).method_22913(uvRange.minU(), uvRange.minV());
                builder.method_22918(matrix4f, -30.0f, -30.0f, 30.0f).method_22913(uvRange.minU(), uvRange.maxV());
                builder.method_22918(matrix4f, 30.0f, -30.0f, 30.0f).method_22913(uvRange.maxU(), uvRange.maxV());
                builder.method_22918(matrix4f, 30.0f, -30.0f, -30.0f).method_22913(uvRange.maxU(), uvRange.minV());
            }
            this.skyBufferIndices = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)vertexFormatMode);
            try (class_9801 meshData = builder.method_60800();){
                this.skyBufferIndexCount = meshData.method_60822().comp_751();
                this.skyBuffer = RenderSystem.getDevice().createBuffer(() -> "OptiFine Skybox", BufferType.VERTICES, BufferUsage.STATIC_WRITE, meshData.method_60818());
            }
        }
    }

    public static RenderPipeline getSkyboxPipeline(@Nullable BlendFunction blendFunction) {
        RenderPipeline.Builder builder = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelinesAccessor.optiboxes$getMatricesProjectionSnippet()});
        builder.withLocation(OptiBoxesClient.id("pipeline/custom_skybox"));
        builder.withVertexShader(OptiBoxesClient.id("core/custom_skybox"));
        builder.withFragmentShader(OptiBoxesClient.id("core/custom_skybox"));
        builder.withDepthWrite(false);
        builder.withColorWrite(true, false);
        if (blendFunction != null) {
            builder.withBlend(blendFunction.toNative());
        }
        builder.withSampler("Sampler0");
        builder.withVertexFormat(class_290.field_1585, VertexFormat.class_5596.field_27382);
        return builder.build();
    }

    public void renderSkybox(OptiFineSkybox optiFineSkybox, Matrix4fStack modelViewStack, class_1937 level, float tickDelta) {
        long dayTime = level.method_8532();
        int clampedTimeOfDay = (int)(dayTime % 24000L);
        float skyAngle = level.method_30274(tickDelta);
        float thunderLevel = level.method_8478(tickDelta);
        float rainLevel = level.method_8430(tickDelta);
        if (rainLevel > 0.0f) {
            thunderLevel /= rainLevel;
        }
        for (OptiFineSkyLayer optiFineSkyLayer : optiFineSkybox.getLayers().stream().filter(layer -> layer.isActive(dayTime, clampedTimeOfDay)).toList()) {
            this.renderSkyLayer(optiFineSkyLayer, modelViewStack, level, clampedTimeOfDay, skyAngle, rainLevel, thunderLevel, optiFineSkybox.getConditionAlphaFor(optiFineSkyLayer));
        }
    }

    public void renderSkyLayer(OptiFineSkyLayer optiFineSkyLayer, Matrix4fStack modelViewStack, class_1937 level, int timeOfDay, float skyAngle, float rainGradient, float thunderGradient, float conditionAlpha) {
        float fadeAlpha;
        float weatherAlpha = CommonUtils.getWeatherAlpha(optiFineSkyLayer.weatherConditions(), rainGradient, thunderGradient);
        float finalAlpha = class_3532.method_15363((float)(conditionAlpha * weatherAlpha * (fadeAlpha = optiFineSkyLayer.fade().getAlpha(timeOfDay))), (float)0.0f, (float)1.0f);
        if (!(finalAlpha < 1.0E-4f) && this.skyBuffer != null) {
            modelViewStack.pushMatrix();
            if (optiFineSkyLayer.rotate()) {
                modelViewStack.rotate((Quaternionfc)new Quaternionf(new AxisAngle4f(this.getAngle(level, skyAngle, optiFineSkyLayer.speed()), (Vector3fc)optiFineSkyLayer.axis())));
            }
            RenderPipeline renderPipeline = this.renderPipelineCache.computeIfAbsent(optiFineSkyLayer.source(), resourceLocation -> {
                RenderPipeline pipeline = OptiFineSkyRenderer.getSkyboxPipeline(optiFineSkyLayer.blend().getBlendFunction());
                IrisUtil.assignPipeline(pipeline, IrisPipeline.SKY_TEXTURED);
                return pipeline;
            });
            class_310 minecraft = class_310.method_1551();
            class_276 renderTarget = minecraft.method_1522();
            class_1044 skyTexture = minecraft.method_1531().method_4619(optiFineSkyLayer.source());
            GpuTexture colorTexture = renderTarget.method_30277();
            GpuTexture depthTexture = renderTarget.method_30278();
            GpuBuffer indexBuffer = this.skyBufferIndices.method_68274(this.skyBufferIndexCount);
            try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(colorTexture, OptionalInt.empty(), depthTexture, OptionalDouble.empty());){
                renderPass.setPipeline(renderPipeline);
                renderPass.setVertexBuffer(0, this.skyBuffer);
                renderPass.setIndexBuffer(indexBuffer, this.skyBufferIndices.method_31924());
                renderPass.bindSampler("Sampler0", skyTexture.method_68004());
                renderPass.drawIndexed(0, this.skyBufferIndexCount);
            }
            modelViewStack.popMatrix();
        }
    }

    private float getAngle(class_1937 level, float skyAngle, float speed) {
        float angleDayStart = 0.0f;
        if (speed != (float)Math.round(speed)) {
            long currentWorldDay = (level.method_8532() + 18000L) / 24000L;
            double anglePerDay = speed % 1.0f;
            double currentAngle = (double)currentWorldDay * anglePerDay;
            angleDayStart = (float)(currentAngle % 1.0);
        }
        return (float)Math.toRadians(360.0f * (angleDayStart + skyAngle * speed));
    }

    public void clearCache() {
        this.renderPipelineCache.clear();
    }
}

