/*
 * Decompiled with CFR 0.152.
 */
package btw.lowercase.lightconfig.lib.v1.field;

import btw.lowercase.lightconfig.lib.ConfigTranslate;
import btw.lowercase.lightconfig.lib.v1.Config;
import btw.lowercase.lightconfig.lib.v1.field.GenericConfigField;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_7919;

public class EnumConfigField<T extends Enum<T>>
extends GenericConfigField<T> {
    private final Class<T> enumClazz;

    public EnumConfigField(Config config, String name, T defaultValue, Class<T> clazz) {
        super(config, name, defaultValue);
        this.enumClazz = clazz;
    }

    @Override
    public void load(JsonObject object) throws Exception {
        JsonPrimitive primitive;
        if (!object.has(this.name)) {
            throw new Exception("Failed to load value for '" + this.name + "', object didn't contain a value for it.");
        }
        JsonElement element = object.get(this.name);
        if (!element.isJsonPrimitive() || element instanceof JsonPrimitive && !(primitive = (JsonPrimitive)element).isString()) {
            throw new Exception("Failed to load value for '" + this.name + "', type does not match.");
        }
        Optional<Enum> opt = Arrays.stream((Enum[])this.enumClazz.getEnumConstants()).filter(cons -> cons.name().equals(element.getAsString())).findFirst();
        this.setValue(opt.orElseThrow(() -> new Exception("Failed to load value for '" + this.name + "', invalid enum value.")));
    }

    @Override
    public void save(JsonObject object) {
        object.addProperty(this.name, ((Enum)this.value).name());
    }

    @Override
    public class_339 createWidget() {
        String translationKey = this.getTranslationKey();
        class_5250 translate = class_2561.method_43471((String)translationKey);
        return class_4185.method_46430((class_2561)this.getDisplayText((class_2561)translate, translationKey), arg_0 -> this.lambda$createWidget$2((class_2561)translate, translationKey, arg_0)).method_46436(class_7919.method_47407((class_2561)ConfigTranslate.tooltip(translationKey))).method_46431();
    }

    private class_2561 getDisplayText(class_2561 translate, String translationKey) {
        return ConfigTranslate.TEMPLATE.apply(translate, (class_2561)class_2561.method_43471((String)(translationKey + "." + ((Enum)this.getValue()).name())));
    }

    private /* synthetic */ void lambda$createWidget$2(class_2561 translate, String translationKey, class_4185 button) {
        Enum[] constants = (Enum[])this.enumClazz.getEnumConstants();
        Enum next = constants[(((Enum)this.value).ordinal() + 1) % constants.length];
        this.setValue(next);
        button.method_25355(this.getDisplayText(translate, translationKey));
    }
}

