/*
 * Decompiled with CFR 0.152.
 */
package btw.lowercase.optiboxes;

import btw.lowercase.optiboxes.command.OptiboxesCommand;
import btw.lowercase.optiboxes.config.OptiBoxesConfig;
import btw.lowercase.optiboxes.skybox.OptiFineSkybox;
import btw.lowercase.optiboxes.skybox.SkyboxManager;
import btw.lowercase.optiboxes.utils.CommonUtils;
import btw.lowercase.optiboxes.utils.SkyboxResourceHelper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OptiBoxesClient
implements ClientModInitializer {
    public static final String MOD_ID = "optiboxes";
    private static final String OPTIFINE_SKY_PARENT = "optifine/sky";
    private static final String SKY_PATTERN_ENDING = "(?<world>[\\w-]+)/(?<name>\\w+).properties$";
    private static final Pattern OPTIFINE_SKY_PATTERN = Pattern.compile("optifine/sky/(?<world>[\\w-]+)/(?<name>\\w+).properties$");
    private static final String MCPATCHER_SKY_PARENT = "mcpatcher/sky";
    private static final Pattern MCPATCHER_SKY_PATTERN = Pattern.compile("mcpatcher/sky/(?<world>[\\w-]+)/(?<name>\\w+).properties$");
    private static OptiBoxesConfig CONFIG_INSTANCE = null;
    private static ModContainer MOD_CONTAINER = null;
    public static final Logger LOGGER = LoggerFactory.getLogger(OptiBoxesClient.class);

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public static OptiBoxesConfig getConfig() {
        if (CONFIG_INSTANCE == null) {
            CONFIG_INSTANCE = new OptiBoxesConfig(FabricLoader.getInstance().getConfigDir().resolve("optiboxes.json"));
        }
        return CONFIG_INSTANCE;
    }

    public static ModContainer getModContainer() {
        if (MOD_CONTAINER == null) {
            MOD_CONTAINER = (ModContainer)FabricLoader.getInstance().getModContainer(MOD_ID).orElseThrow(() -> new RuntimeException("Mod metadata container was null."));
        }
        return MOD_CONTAINER;
    }

    public void onInitializeClient() {
        OptiBoxesClient.getConfig().load();
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SkyboxResourceHelper());
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)new OptiboxesCommand()));
    }

    public static void convert(SkyboxResourceHelper skyboxResourceHelper) {
        if (OptiBoxesClient.CONFIG_INSTANCE.processOptiFine.isEnabled()) {
            OptiBoxesClient.parseSkyboxes(skyboxResourceHelper, OPTIFINE_SKY_PARENT, OPTIFINE_SKY_PATTERN);
        }
        if (OptiBoxesClient.CONFIG_INSTANCE.processMCPatcher.isEnabled()) {
            OptiBoxesClient.parseSkyboxes(skyboxResourceHelper, MCPATCHER_SKY_PARENT, MCPATCHER_SKY_PATTERN);
        }
    }

    private static void parseSkyboxes(SkyboxResourceHelper skyboxResourceHelper, String skyParent, Pattern skyPattern) {
        HashMap<String, JsonArray> layers = new HashMap<String, JsonArray>();
        layers.put("world0", new JsonArray());
        layers.put("world-1", new JsonArray());
        layers.put("world1", new JsonArray());
        skyboxResourceHelper.searchIn(skyParent).filter(id -> id.method_12832().endsWith(".properties")).sorted(Comparator.comparing(class_2960::method_12832, (id1, id2) -> {
            Matcher matcherId1 = skyPattern.matcher((CharSequence)id1);
            Matcher matcherId2 = skyPattern.matcher((CharSequence)id2);
            if (matcherId1.find() && matcherId2.find()) {
                int a = CommonUtils.safeParseInteger(matcherId1.group("name").replace("sky", ""), -1);
                int b = CommonUtils.safeParseInteger(matcherId2.group("name").replace("sky", ""), -1);
                if (a >= 0 && b >= 0) {
                    return a - b;
                }
            }
            return 0;
        })).forEach(id -> {
            Matcher matcher = skyPattern.matcher(id.method_12832());
            if (matcher.find()) {
                String world = matcher.group("world");
                String name = matcher.group("name");
                if (world == null || name == null) {
                    return;
                }
                if (name.equals("moon_phases") || name.equals("sun")) {
                    LOGGER.warn("Skipping {}, moon_phases/sun aren't currently supported!", id);
                    return;
                }
                InputStream inputStream = skyboxResourceHelper.getInputStream((class_2960)id);
                if (inputStream == null) {
                    LOGGER.error("Error trying to read namespaced identifier: {}", id);
                    return;
                }
                Properties properties = new Properties();
                try {
                    properties.load(inputStream);
                }
                catch (IOException e) {
                    LOGGER.error("Error trying to read properties from: {}", id);
                    return;
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("Error trying to close input stream at namespaced identifier: {}", id);
                    }
                }
                JsonObject json = CommonUtils.convertOptiFineSkyProperties(skyboxResourceHelper, properties, id);
                if (json != null && layers.containsKey(world)) {
                    ((JsonArray)layers.get(world)).add((JsonElement)json);
                }
            }
        });
        for (Map.Entry entry : layers.entrySet()) {
            JsonObject skyJson = new JsonObject();
            JsonArray skyLayers = (JsonArray)entry.getValue();
            if (skyLayers.isEmpty()) continue;
            skyJson.add("layers", (JsonElement)skyLayers);
            skyJson.addProperty("world", (switch ((String)entry.getKey()) {
                case "world-1" -> class_1937.field_25180;
                case "world1" -> class_1937.field_25181;
                default -> class_1937.field_25179;
            }).method_29177().toString());
            SkyboxManager.INSTANCE.addSkybox((OptiFineSkybox)((Pair)OptiFineSkybox.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)skyJson).getOrThrow()).getFirst());
        }
    }
}

