/*
 * Decompiled with CFR 0.152.
 */
package btw.lowercase.optiboxes.skybox;

import btw.lowercase.optiboxes.OptiBoxesClient;
import btw.lowercase.optiboxes.skybox.OptiFineSkyLayer;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_5321;
import net.minecraft.class_638;

public class OptiFineSkybox {
    public static final Codec<OptiFineSkybox> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)OptiFineSkyLayer.CODEC.listOf().optionalFieldOf("layers", (Object)ImmutableList.of()).forGetter(OptiFineSkybox::getLayers), (App)class_1937.field_25178.fieldOf("world").forGetter(OptiFineSkybox::getWorldResourceKey)).apply((Applicative)instance, OptiFineSkybox::new));
    private final List<OptiFineSkyLayer> layers;
    private final class_5321<class_1937> worldResourceKey;
    private final Map<OptiFineSkyLayer, Float> optiFineSkyLayerAlphaMap = new HashMap<OptiFineSkyLayer, Float>();
    private boolean active = true;

    public OptiFineSkybox(List<OptiFineSkyLayer> layers, class_5321<class_1937> worldResourceKey) {
        this.layers = layers;
        this.worldResourceKey = worldResourceKey;
    }

    public void tick(class_638 level) {
        this.active = true;
        if (level.method_27983().equals(this.worldResourceKey) || OptiBoxesClient.getConfig().showOverworldForUnknownDimension.isEnabled() && this.worldResourceKey.equals((Object)class_1937.field_25179) && !level.method_27983().equals(class_1937.field_25180) && !level.method_27983().equals(class_1937.field_25181)) {
            this.layers.forEach(layer -> this.optiFineSkyLayerAlphaMap.put((OptiFineSkyLayer)layer, Float.valueOf(layer.getPositionBrightness((class_1937)level, this.getConditionAlphaFor((OptiFineSkyLayer)layer)))));
        } else {
            this.layers.forEach(layer -> this.optiFineSkyLayerAlphaMap.put((OptiFineSkyLayer)layer, Float.valueOf(-1.0f)));
            this.active = false;
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public float getConditionAlphaFor(OptiFineSkyLayer optiFineSkyLayer) {
        return this.optiFineSkyLayerAlphaMap.getOrDefault(optiFineSkyLayer, Float.valueOf(-1.0f)).floatValue();
    }

    public List<OptiFineSkyLayer> getLayers() {
        return this.layers;
    }

    public class_5321<class_1937> getWorldResourceKey() {
        return this.worldResourceKey;
    }
}

