/*
 * Decompiled with CFR 0.152.
 */
package btw.lowercase.lightconfig.lib.v1;

import btw.lowercase.lightconfig.lib.v1.ConfigSerializer;
import btw.lowercase.lightconfig.lib.v1.field.AbstractConfigField;
import btw.lowercase.lightconfig.lib.v1.field.BooleanConfigField;
import btw.lowercase.lightconfig.lib.v1.field.EnumConfigField;
import btw.lowercase.lightconfig.lib.v1.field.NumericConfigField;
import btw.lowercase.lightconfig.lib.v1.field.StringConfigField;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Config {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().create();
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final List<AbstractConfigField<?>> configFields = new ArrayList();
    protected final ModContainer modContainer;
    protected final Path path;
    protected final ConfigSerializer<? extends JsonElement> serializer;

    public Config(ModContainer modContainer, Path path) {
        this.modContainer = modContainer;
        this.path = path;
        this.serializer = new ConfigSerializer();
    }

    public BooleanConfigField booleanFieldOf(String name, boolean defaultValue) {
        BooleanConfigField field = new BooleanConfigField(this, name, defaultValue);
        this.configFields.add(field);
        return field;
    }

    public StringConfigField stringFieldOf(String name, String defaultValue) {
        StringConfigField field = new StringConfigField(this, name, defaultValue);
        this.configFields.add(field);
        return field;
    }

    public <T extends Number> NumericConfigField<T> numericFieldOf(String name, T defaultValue) {
        NumericConfigField<T> field = new NumericConfigField<T>(this, name, defaultValue);
        this.configFields.add(field);
        return field;
    }

    public <T extends Enum<T>> EnumConfigField<T> enumFieldOf(String name, T defaultValue, Class<T> clazz) {
        EnumConfigField<T> field = new EnumConfigField<T>(this, name, defaultValue, clazz);
        this.configFields.add(field);
        return field;
    }

    public void load() {
        if (!this.path.toFile().exists()) {
            this.logger.info("Config file doesn't exist! Creating one...");
            this.save();
            return;
        }
        try {
            String json = Files.readString(this.path);
            JsonObject object = (JsonObject)GSON.fromJson(json, JsonObject.class);
            if (object == null) {
                this.logger.warn("Failed to load config! Defaulting to original settings.");
            } else {
                this.configFields.forEach(field -> {
                    try {
                        field.load(object);
                    }
                    catch (Exception exception) {
                        this.logger.warn(exception.getMessage());
                    }
                });
            }
        }
        catch (Exception ignored) {
            this.logger.warn("Failed to load config! Error occured when reading file.");
            return;
        }
        this.logger.info("Config successfully loaded!");
    }

    public void save() {
        JsonObject object = new JsonObject();
        this.configFields.forEach(field -> {
            try {
                field.save(object);
            }
            catch (Exception ignored) {
                this.logger.warn("Failed to save config field '{}'!", (Object)field.getName());
            }
        });
        try {
            Files.write(this.path, GSON.toJson((JsonElement)object).getBytes(), new OpenOption[0]);
        }
        catch (Exception ignored) {
            this.logger.warn("Failed to save config!");
            return;
        }
        this.logger.info("Config successfully saved!");
    }

    public void reset() {
        this.configFields.forEach(AbstractConfigField::restore);
        this.save();
    }

    public abstract class_437 getConfigScreen(@Nullable class_437 var1);

    public Logger getLogger() {
        return this.logger;
    }

    public List<AbstractConfigField<?>> getConfigFields() {
        return this.configFields;
    }

    public ModContainer getModContainer() {
        return this.modContainer;
    }

    public Path getPath() {
        return this.path;
    }
}

