/*
 * Decompiled with CFR 0.152.
 */
package btw.lowercase.skyboxify.skybox;

import btw.lowercase.skyboxify.Skyboxify;
import btw.lowercase.skyboxify.skybox.Skybox;
import btw.lowercase.skyboxify.skybox.SkyboxSkyRenderer;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;

public final class SkyboxManager {
    public static final SkyboxManager INSTANCE = new SkyboxManager();
    private final List<Skybox> loadedSkyboxes = new ArrayList<Skybox>();
    private final List<Skybox> activeSkyboxes = new LinkedList<Skybox>();

    private SkyboxManager() {
    }

    public void addSkybox(Skybox skybox) {
        Preconditions.checkNotNull((Object)skybox, (Object)"Skybox was null");
        this.loadedSkyboxes.add(skybox);
    }

    public void clearSkyboxes() {
        class_310.method_1551().execute(SkyboxSkyRenderer.INSTANCE::clearCache);
        this.loadedSkyboxes.clear();
        this.activeSkyboxes.clear();
    }

    public void tick(class_638 level) {
        if (!Skyboxify.getConfig().enabled.isEnabled()) {
            return;
        }
        for (Skybox skybox : this.loadedSkyboxes) {
            skybox.tick(level);
        }
        this.activeSkyboxes.removeIf(optiFineSkybox -> !optiFineSkybox.isActive());
        for (Skybox skybox : this.loadedSkyboxes) {
            if (this.activeSkyboxes.contains(skybox) || !skybox.isActive()) continue;
            this.activeSkyboxes.add(skybox);
        }
    }

    public boolean isEnabled(class_1937 level) {
        return Skyboxify.getConfig().enabled.isEnabled() && !this.activeSkyboxes.isEmpty() && level != null;
    }

    public List<Skybox> getSkiesFor(class_5321<@NotNull class_1937> resourceKey) {
        return this.getActiveSkyboxes().stream().filter(skybox -> resourceKey.equals(skybox.getWorldResourceKey())).toList();
    }

    public boolean containsEnabled(class_5321<@NotNull class_1937> resourceKey) {
        return !this.getSkiesFor(resourceKey).isEmpty();
    }

    @Generated
    public List<Skybox> getActiveSkyboxes() {
        return this.activeSkyboxes;
    }
}

