/*
 * Decompiled with CFR 0.152.
 */
package btw.lowercase.skyboxify.skybox;

import btw.lowercase.skyboxify.skybox.SkyLayer;
import btw.lowercase.skyboxify.skybox.SkyPart;
import btw.lowercase.skyboxify.skybox.Skybox;
import btw.lowercase.skyboxify.skybox.components.UVRange;
import btw.lowercase.skyboxify.utils.CommonUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1937;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import net.minecraft.class_8555;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public final class SkyboxSkyRenderer {
    public static final SkyboxSkyRenderer INSTANCE = new SkyboxSkyRenderer();
    private class_291 skyBuffer;

    private SkyboxSkyRenderer() {
        class_310.method_1551().method_63588(this::buildSky);
    }

    private void buildSky() {
        class_293 vertexFormat = class_290.field_1585;
        try (class_9799 byteBufferBuilder = new class_9799(vertexFormat.method_1362() * SkyPart.COUNT * 4);){
            class_293.class_5596 vertexFormatMode = class_293.class_5596.field_27382;
            class_287 builder = new class_287(byteBufferBuilder, vertexFormatMode, vertexFormat);
            for (SkyPart skyPart : SkyPart.VALUES) {
                Matrix4f matrix4f = skyPart.getRotationMatrix();
                UVRange uvRange = skyPart.getUVRange();
                float quadSize = 30.0f;
                builder.method_22918(matrix4f, -30.0f, -30.0f, -30.0f).method_22913(uvRange.minU(), uvRange.minV());
                builder.method_22918(matrix4f, -30.0f, -30.0f, 30.0f).method_22913(uvRange.minU(), uvRange.maxV());
                builder.method_22918(matrix4f, 30.0f, -30.0f, 30.0f).method_22913(uvRange.maxU(), uvRange.maxV());
                builder.method_22918(matrix4f, 30.0f, -30.0f, -30.0f).method_22913(uvRange.maxU(), uvRange.minV());
            }
            try (class_9801 meshData = builder.method_60800();){
                this.skyBuffer = new class_291(class_8555.field_54340);
                this.skyBuffer.method_1353();
                this.skyBuffer.method_1352(meshData);
                class_291.method_1354();
            }
        }
    }

    public void renderSkybox(Skybox skybox, Matrix4f modelViewMatrix, class_638 level, float tickDelta) {
        if (this.skyBuffer != null) {
            long dayTime = level.method_8532();
            int clampedTimeOfDay = (int)(dayTime % 24000L);
            float skyAngle = this.getTimeOfDay((class_1937)level);
            float rainLevel = level.method_8430(tickDelta);
            float thunderLevel = level.method_8478(tickDelta);
            if (rainLevel > 0.0f) {
                thunderLevel /= rainLevel;
            }
            for (SkyLayer skyLayer : skybox.getLayers().stream().filter(layer -> layer.isActive(dayTime, clampedTimeOfDay)).toList()) {
                this.renderSkyLayer(skyLayer, new Matrix4f((Matrix4fc)modelViewMatrix), (class_1937)level, clampedTimeOfDay, skyAngle, rainLevel, thunderLevel, skybox.getConditionAlphaFor(skyLayer));
            }
        }
    }

    private void renderSkyLayer(SkyLayer skyLayer, Matrix4f modelViewMatrix, class_1937 level, int timeOfDay, float skyAngle, float rainLevel, float thunderLevel, float conditionAlpha) {
        float fadeAlpha;
        float weatherAlpha = CommonUtils.getWeatherAlpha(skyLayer.weatherConditions(), rainLevel, thunderLevel);
        float finalAlpha = class_3532.method_15363((float)(conditionAlpha * weatherAlpha * (fadeAlpha = skyLayer.fade().getAlpha(timeOfDay))), (float)0.0f, (float)1.0f);
        if (!(finalAlpha < 1.0E-4f)) {
            if (skyLayer.rotate()) {
                modelViewMatrix.rotate((Quaternionfc)new Quaternionf(new AxisAngle4f(this.getAngle(level, skyAngle, skyLayer.speed()), skyLayer.axis())));
            }
            RenderSystem.setShaderTexture((int)0, (class_2960)skyLayer.source());
            RenderSystem.setShader((class_10156)class_10142.field_53879);
            RenderSystem.depthMask((boolean)false);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            skyLayer.blend().apply(finalAlpha);
            this.skyBuffer.method_1353();
            this.skyBuffer.method_34427(modelViewMatrix, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
            class_291.method_1354();
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private float getAngle(class_1937 level, float skyAngle, float speed) {
        float angleDayStart = 0.0f;
        if (speed != (float)Math.round(speed)) {
            long currentWorldDay = (level.method_8532() + 18000L) / 24000L;
            double anglePerDay = speed % 1.0f;
            double currentAngle = (double)currentWorldDay * anglePerDay;
            angleDayStart = (float)(currentAngle % 1.0);
        }
        return (float)Math.toRadians(360.0f * (angleDayStart + skyAngle * speed));
    }

    public void clearCache() {
    }

    private float getTimeOfDay(class_1937 level) {
        return level.method_30274(1.0f);
    }
}

