/*
 * Decompiled with CFR 0.152.
 */
package btw.lowercase.lightconfig.lib.v1.field;

import btw.lowercase.lightconfig.lib.v1.Config;
import btw.lowercase.lightconfig.lib.v1.field.GenericConfigField;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;

public class NumericConfigField<T extends Number>
extends GenericConfigField<T> {
    public NumericConfigField(Config config, String name, T defaultValue) {
        super(config, name, defaultValue);
    }

    @Override
    public void load(JsonObject object) throws Exception {
        JsonPrimitive primitive;
        if (!object.has(this.name)) {
            throw new Exception("Failed to load value for '" + this.name + "', object didn't contain a value for it.");
        }
        JsonElement element = object.get(this.name);
        if (!element.isJsonPrimitive() || element instanceof JsonPrimitive && !(primitive = (JsonPrimitive)element).isNumber()) {
            throw new Exception("Failed to load value for '" + this.name + "', type does not match.");
        }
        this.setValue(element.getAsNumber());
    }

    @Override
    public void save(JsonObject object) {
        object.addProperty(this.name, (Number)this.value);
    }
}

