/*
 * Decompiled with CFR 0.152.
 */
package btw.lowercase.optiboxes.utils;

import btw.lowercase.optiboxes.OptiBoxesClient;
import btw.lowercase.optiboxes.utils.SkyboxResourceHelper;
import btw.lowercase.optiboxes.utils.components.Range;
import btw.lowercase.optiboxes.utils.components.Weather;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.minecraft.class_1047;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommonUtils {
    private static final Pattern OPTIFINE_RANGE_SEPARATOR = Pattern.compile("(\\d|\\))-(\\d|\\()");
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonUtils.class);

    private CommonUtils() {
    }

    @Nullable
    public static JsonObject convertOptiFineSkyProperties(SkyboxResourceHelper skyboxResourceHelper, Properties properties, class_2960 propertiesResourceLocation) {
        List<Range> rangeEntries;
        List<Range> rangeEntries2;
        JsonObject jsonObject = new JsonObject();
        Optional<class_2960> sourceTexture = Optional.ofNullable(CommonUtils.parseSourceTexture(properties.getProperty("source", null), skyboxResourceHelper, propertiesResourceLocation));
        if (sourceTexture.isEmpty() && OptiBoxesClient.getConfig().ignoreBrokenSkies.isEnabled()) {
            return null;
        }
        jsonObject.addProperty("source", sourceTexture.orElse(class_1047.method_4539()).toString());
        if (properties.containsKey("blend")) {
            jsonObject.addProperty("blend", properties.getProperty("blend"));
        }
        JsonObject fade = new JsonObject();
        if (properties.containsKey("startFadeIn") && properties.containsKey("endFadeIn") && properties.containsKey("endFadeOut")) {
            int startFadeOut;
            int startFadeIn = CommonUtils.toTickTime(properties.getProperty("startFadeIn"));
            int endFadeIn = CommonUtils.toTickTime(properties.getProperty("endFadeIn"));
            int endFadeOut = CommonUtils.toTickTime(properties.getProperty("endFadeOut"));
            if (properties.containsKey("startFadeOut")) {
                startFadeOut = CommonUtils.toTickTime(properties.getProperty("startFadeOut"));
            } else {
                startFadeOut = endFadeOut - (endFadeIn - startFadeIn);
                if (startFadeIn <= startFadeOut && endFadeIn >= startFadeOut) {
                    startFadeOut = endFadeOut;
                }
            }
            fade.addProperty("startFadeIn", (Number)CommonUtils.normalizeTickTime(startFadeIn));
            fade.addProperty("endFadeIn", (Number)CommonUtils.normalizeTickTime(endFadeIn));
            fade.addProperty("startFadeOut", (Number)CommonUtils.normalizeTickTime(startFadeOut));
            fade.addProperty("endFadeOut", (Number)CommonUtils.normalizeTickTime(endFadeOut));
        } else {
            fade.addProperty("alwaysOn", Boolean.valueOf(true));
        }
        jsonObject.add("fade", (JsonElement)fade);
        if (properties.containsKey("speed")) {
            float value = CommonUtils.safeParseFloat(properties.getProperty("speed"), 1.0f);
            if (value != Float.MIN_VALUE) {
                jsonObject.addProperty("speed", (Number)Float.valueOf(value));
            } else {
                LOGGER.warn("Invalid speed provided in skybox.");
            }
        }
        if (properties.containsKey("rotate")) {
            jsonObject.addProperty("rotate", Boolean.valueOf(CommonUtils.safeParseBoolean(properties.getProperty("rotate"), true)));
        }
        if (properties.containsKey("transition")) {
            jsonObject.addProperty("transition", (Number)Float.valueOf(CommonUtils.safeParseFloat(properties.getProperty("transition"), 1.0f)));
        }
        if (properties.containsKey("axis")) {
            jsonObject.add("axis", (JsonElement)CommonUtils.parseAxis(properties.getProperty("axis")));
        }
        if (properties.containsKey("weather")) {
            String[] weathers = properties.getProperty("weather").trim().split(" ");
            JsonArray jsonWeather = new JsonArray();
            if (weathers.length > 0) {
                Arrays.stream(weathers).forEach(arg_0 -> ((JsonArray)jsonWeather).add(arg_0));
            } else {
                jsonWeather.add("clear");
            }
            jsonObject.add("weather", (JsonElement)jsonWeather);
        }
        if (properties.containsKey("biomes")) {
            String[] biomes;
            String biomesString = properties.getProperty("biomes").trim();
            if (biomesString.startsWith("!")) {
                jsonObject.addProperty("biomeInclusion", Boolean.valueOf(false));
                biomesString = biomesString.substring(1);
            }
            if ((biomes = biomesString.trim().split(" ")).length > 0) {
                JsonArray jsonBiomes = new JsonArray();
                Arrays.stream(biomes).filter(class_2960::method_20208).forEach(arg_0 -> ((JsonArray)jsonBiomes).add(arg_0));
                jsonObject.add("biomes", (JsonElement)jsonBiomes);
            }
        }
        if (properties.containsKey("heights") && !(rangeEntries2 = CommonUtils.parseRangeEntriesNegative(properties.getProperty("heights"))).isEmpty()) {
            JsonArray jsonYRanges = new JsonArray();
            rangeEntries2.stream().map(range -> (JsonElement)Range.CODEC.encode(range, (DynamicOps)JsonOps.INSTANCE, (Object)new JsonObject()).getOrThrow()).forEach(arg_0 -> ((JsonArray)jsonYRanges).add(arg_0));
            jsonObject.add("heights", (JsonElement)jsonYRanges);
        }
        if (properties.containsKey("days") && !(rangeEntries = CommonUtils.parseRangeEntries(properties.getProperty("days"))).isEmpty()) {
            JsonObject loopObject = new JsonObject();
            JsonArray loopRange = new JsonArray();
            rangeEntries.stream().map(range -> (JsonElement)Range.CODEC.encode(range, (DynamicOps)JsonOps.INSTANCE, (Object)new JsonObject()).getOrThrow()).forEach(arg_0 -> ((JsonArray)loopRange).add(arg_0));
            int value = 8;
            if (properties.containsKey("daysLoop")) {
                value = CommonUtils.safeParseInteger(properties.getProperty("daysLoop"), 8);
            }
            loopObject.addProperty("days", (Number)value);
            loopObject.add("ranges", (JsonElement)loopRange);
            jsonObject.add("loop", (JsonElement)loopObject);
        }
        return jsonObject;
    }

    @Nullable
    public static class_2960 parseSourceTexture(String source, SkyboxResourceHelper skyboxResourceHelper, class_2960 propertiesId) {
        class_2960 textureId;
        String path;
        String namespace;
        if (source == null) {
            namespace = propertiesId.method_12836();
            path = propertiesId.method_12832().replace(".properties", ".png");
        } else if (source.startsWith("./")) {
            namespace = propertiesId.method_12836();
            String fileName = propertiesId.method_12832().split("/")[propertiesId.method_12832().split("/").length - 1];
            path = propertiesId.method_12832().replace(fileName, source.substring(2));
        } else {
            String[] parts = source.split("/", 3);
            if (parts.length == 3 && parts[0].equals("assets")) {
                namespace = parts[1];
                path = parts[2];
            } else {
                class_2960 location = class_2960.method_12829((String)source);
                if (location != null) {
                    namespace = location.method_12836();
                    path = location.method_12832();
                } else {
                    return null;
                }
            }
        }
        try {
            textureId = class_2960.method_60655((String)namespace, (String)path);
        }
        catch (class_151 e) {
            LOGGER.error("Failed to read texture path '{}:{}' as resource location", (Object)namespace, (Object)path);
            return null;
        }
        InputStream textureInputStream = skyboxResourceHelper.getInputStream(textureId);
        if (textureInputStream == null) {
            LOGGER.error("Failed to load texture input stream for texture '{}'", (Object)textureId);
            return null;
        }
        try {
            textureInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return textureId;
    }

    public static int toTickTime(String time) {
        String[] parts = time.split(":");
        if (parts.length == 2) {
            int h = CommonUtils.safeParseInteger(parts[0], -1);
            int m = CommonUtils.safeParseInteger(parts[1], -1);
            if (h >= 0 && h <= 23 && m >= 0 && m <= 59) {
                if ((h -= 6) < 0) {
                    h += 24;
                }
                return h * 1000 + (int)((float)m / 60.0f * 1000.0f);
            }
        }
        LOGGER.warn("Invalid time: \"{}\" in skybox.", (Object)time);
        return -1;
    }

    public static int normalizeTickTime(int tickTime) {
        int result = tickTime % 24000;
        if (result < 0) {
            result += 24000;
        }
        return result;
    }

    public static List<Range> parseRangeEntries(String source) {
        String[] parts;
        ArrayList<Range> rangeEntries = new ArrayList<Range>();
        for (String part : parts = source.trim().split(" ,")) {
            Range range = CommonUtils.parseRangeEntry(part);
            if (range == null) continue;
            rangeEntries.add(range);
        }
        return rangeEntries;
    }

    @Nullable
    private static Range parseRangeEntry(String part) {
        if (part != null) {
            if (part.contains("-")) {
                String[] parts = part.trim().split("-");
                if (parts.length == 2) {
                    int min = CommonUtils.safeParseInteger(parts[0], -1);
                    int max = CommonUtils.safeParseInteger(parts[1], -1);
                    if (min >= 0 && max >= 0) {
                        return new Range(min, max);
                    }
                }
            } else {
                int value = CommonUtils.safeParseInteger(part, -1);
                if (value >= 0) {
                    return new Range(value, value);
                }
            }
        }
        return null;
    }

    public static List<Range> parseRangeEntriesNegative(String source) {
        String[] parts;
        ArrayList<Range> rangeEntries = new ArrayList<Range>();
        for (String part : parts = source.trim().split(" ,")) {
            Range range = CommonUtils.parseRangeEntryNegative(part);
            if (range == null) continue;
            rangeEntries.add(range);
        }
        return rangeEntries;
    }

    @Nullable
    private static Range parseRangeEntryNegative(String part) {
        if (part != null) {
            String s = OPTIFINE_RANGE_SEPARATOR.matcher(part).replaceAll("$1=$2");
            if (s.contains("=")) {
                String[] parts = s.split("=");
                if (parts.length == 2) {
                    int j = CommonUtils.safeParseInteger(CommonUtils.stripBrackets(parts[0]), Integer.MIN_VALUE);
                    int k = CommonUtils.safeParseInteger(CommonUtils.stripBrackets(parts[1]), Integer.MIN_VALUE);
                    if (j != Integer.MIN_VALUE && k != Integer.MIN_VALUE) {
                        return new Range(Math.min(j, k), Math.max(j, k));
                    }
                }
            } else {
                int i = CommonUtils.safeParseInteger(CommonUtils.stripBrackets(part), Integer.MIN_VALUE);
                if (i != Integer.MIN_VALUE) {
                    return new Range(i, i);
                }
            }
        }
        return null;
    }

    private static String stripBrackets(String str) {
        return str.startsWith("(") && str.endsWith(")") ? str.substring(1, str.length() - 1) : str;
    }

    public static JsonArray parseAxis(String axisString) {
        float z;
        float y;
        float x;
        String[] parts = axisString.trim().replaceAll(" +", " ").split(" ");
        JsonArray newAxis = new JsonArray(3);
        boolean valid = false;
        if (parts.length == 3 && (x = CommonUtils.safeParseFloat(parts[0], Float.MIN_VALUE)) * x + (y = CommonUtils.safeParseFloat(parts[1], Float.MIN_VALUE)) * y + (z = CommonUtils.safeParseFloat(parts[2], Float.MIN_VALUE)) * z > 1.0E-5f) {
            newAxis.add((Number)Float.valueOf(z));
            newAxis.add((Number)Float.valueOf(y));
            newAxis.add((Number)Float.valueOf(-x));
            valid = true;
        }
        if (!valid) {
            LOGGER.warn("Invalid axis provided in skybox, setting to default axis.");
            newAxis.add((Number)Float.valueOf(1.0f));
            newAxis.add((Number)Float.valueOf(0.0f));
            newAxis.add((Number)Float.valueOf(0.0f));
        }
        return newAxis;
    }

    public static boolean checkRanges(double value, List<Range> rangeEntries) {
        return rangeEntries.isEmpty() || rangeEntries.stream().anyMatch(range -> com.google.common.collect.Range.closed((Comparable)Float.valueOf(range.min()), (Comparable)Float.valueOf(range.max())).contains((Comparable)Float.valueOf((float)value)));
    }

    public static boolean isInTimeInterval(int currentTime, int startTime, int endTime) {
        if (currentTime < 0 || currentTime >= 24000) {
            return false;
        }
        if (startTime <= endTime) {
            return currentTime >= startTime && currentTime <= endTime;
        }
        return currentTime >= startTime || currentTime <= endTime;
    }

    public static float calculateFadeAlphaValue(float maxAlpha, float minAlpha, int currentTime, int startFadeIn, int endFadeIn, int startFadeOut, int endFadeOut) {
        if (CommonUtils.isInTimeInterval(currentTime, endFadeIn, startFadeOut)) {
            return maxAlpha;
        }
        if (CommonUtils.isInTimeInterval(currentTime, startFadeIn, endFadeIn)) {
            int fadeInDuration = CommonUtils.calculateCyclicTimeDistance(startFadeIn, endFadeIn);
            int timePassedSinceFadeInStart = CommonUtils.calculateCyclicTimeDistance(startFadeIn, currentTime);
            return minAlpha + (float)timePassedSinceFadeInStart / (float)fadeInDuration * (maxAlpha - minAlpha);
        }
        if (CommonUtils.isInTimeInterval(currentTime, startFadeOut, endFadeOut)) {
            int fadeOutDuration = CommonUtils.calculateCyclicTimeDistance(startFadeOut, endFadeOut);
            int timePassedSinceFadeOutStart = CommonUtils.calculateCyclicTimeDistance(startFadeOut, currentTime);
            return maxAlpha + (float)timePassedSinceFadeOutStart / (float)fadeOutDuration * (minAlpha - maxAlpha);
        }
        return minAlpha;
    }

    public static int calculateCyclicTimeDistance(int startTime, int endTime) {
        return (endTime - startTime + 24000) % 24000;
    }

    public static float calculateConditionAlphaValue(float maxAlpha, float minAlpha, float lastAlpha, int duration, boolean in) {
        if (duration == 0) {
            return lastAlpha;
        }
        if (in && maxAlpha == lastAlpha) {
            return maxAlpha;
        }
        if (!in && lastAlpha == minAlpha) {
            return minAlpha;
        }
        float alphaChange = (maxAlpha - minAlpha) / (float)duration;
        float result = in ? lastAlpha + alphaChange : lastAlpha - alphaChange;
        return class_3532.method_15363((float)result, (float)minAlpha, (float)maxAlpha);
    }

    public static Codec<Double> getClampedDoubleCodec(double min, double max) {
        if (min > max) {
            throw new UnsupportedOperationException("Maximum value was lesser than than the minimum value");
        }
        return Codec.DOUBLE.xmap(value -> class_3532.method_15350((double)value, (double)min, (double)max), Function.identity());
    }

    public static float getWeatherAlpha(List<Weather> weatherConditions, float rainStrength, float thunderStrength) {
        float alpha = 1.0f - rainStrength;
        float calculatedRainStrength = rainStrength - thunderStrength;
        float weatherAlpha = 0.0f;
        if (weatherConditions.contains((Object)Weather.CLEAR)) {
            weatherAlpha += alpha;
        }
        if (weatherConditions.contains((Object)Weather.RAIN)) {
            weatherAlpha += calculatedRainStrength;
        }
        if (weatherConditions.contains((Object)Weather.THUNDER)) {
            weatherAlpha += thunderStrength;
        }
        return class_3532.method_15363((float)weatherAlpha, (float)0.0f, (float)1.0f);
    }

    public static Vector3f getMatrixTransform(Matrix4f matrix4f, float x, float y, float z) {
        return new Vector3f(matrix4f.m00() * x + matrix4f.m10() * y + matrix4f.m20() * z + matrix4f.m30(), matrix4f.m01() * x + matrix4f.m11() * y + matrix4f.m21() * z + matrix4f.m31(), matrix4f.m02() * x + matrix4f.m12() * y + matrix4f.m22() * z + matrix4f.m32());
    }

    public static int safeParseInteger(String value, int defaultValue) {
        try {
            return Integer.parseInt(value.trim());
        }
        catch (NumberFormatException exception) {
            return defaultValue;
        }
    }

    public static float safeParseFloat(String value, float defaultValue) {
        try {
            return Float.parseFloat(value.trim());
        }
        catch (NumberFormatException exception) {
            return defaultValue;
        }
    }

    public static boolean safeParseBoolean(String value, boolean defaultValue) {
        try {
            return Boolean.parseBoolean(value.trim());
        }
        catch (NumberFormatException exception) {
            return defaultValue;
        }
    }
}

