/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.debugkeybind.gui;

import dev.boxadactle.boxlib.gui.config.BConfigList;
import dev.boxadactle.boxlib.gui.config.widget.label.BLabel;
import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.debugkeybind.DebugKeybindMain;
import dev.boxadactle.debugkeybind.gui.KeybindButton;
import dev.boxadactle.debugkeybind.gui.ResetButton;
import dev.boxadactle.debugkeybind.keybind.DebugKeybind;
import dev.boxadactle.debugkeybind.keybind.DebugKeybinds;
import dev.boxadactle.debugkeybind.keybind.GlobalKeybind;
import dev.boxadactle.debugkeybind.keybind.KeybindConfig;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_332;
import net.minecraft.class_339;

public class KeybindEntry
extends BConfigList.ConfigEntry {
    public DebugKeybind keybind;
    public BLabel label;
    public KeybindButton keybindButton;
    public ResetButton resetButton;
    Runnable globalRefresh;

    public KeybindEntry(DebugKeybind keybind, Function<KeybindEntry, Boolean> onSelect, Runnable refresh) {
        this.label = new BLabel(keybind.getTranslation());
        this.keybindButton = new KeybindButton(keybind, () -> (Boolean)onSelect.apply(this));
        this.resetButton = new ResetButton(keybind, refresh);
        this.keybind = keybind;
        this.refresh();
        this.globalRefresh = refresh;
    }

    public List<? extends class_339> getWidgets() {
        return List.of(this.label, this.keybindButton, this.resetButton);
    }

    public boolean isInvalid() {
        return false;
    }

    public void updateKey(int code) {
        this.keybindButton.update(code);
        this.refresh();
        this.globalRefresh.run();
    }

    public void resetKey() {
        this.keybindButton.resetKey();
        this.globalRefresh.run();
    }

    public void refresh() {
        this.resetButton.refresh();
        if (this.keybind.isUnbound()) {
            this.keybindButton.updateConflicts(List.of());
            return;
        }
        List<class_2561> collisions = this.keybind.checkConflicts(DebugKeybinds.toList());
        if (!((KeybindConfig)DebugKeybindMain.CONFIG.get()).requireDebugKey || this.keybind instanceof GlobalKeybind) {
            class_304[] mappings = (class_304[])ClientUtils.getOptions().field_1839.clone();
            collisions.addAll(this.keybind.checkMinecraftConflicts(List.of(mappings)));
        }
        this.keybindButton.updateConflicts(collisions);
    }

    public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean b, float v) {
        int keybindWidth = 75;
        int resetWidth = 50;
        int padding = 2;
        this.label.method_46421(this.method_46426() - 25);
        this.label.method_46419(this.method_46427());
        this.label.method_25358(this.method_25368() - keybindWidth - resetWidth - padding);
        this.label.method_25394(guiGraphics, mouseX, mouseY, v);
        this.keybindButton.method_46421(this.method_46426() + this.method_25368() - keybindWidth - resetWidth - padding);
        this.keybindButton.method_46419(this.method_46427());
        this.keybindButton.method_25358(keybindWidth);
        this.keybindButton.method_25394(guiGraphics, mouseX, mouseY, v);
        this.resetButton.method_46421(this.method_46426() + this.method_25368() - resetWidth);
        this.resetButton.method_46419(this.method_46427());
        this.resetButton.method_25358(resetWidth);
        this.resetButton.method_25394(guiGraphics, mouseX, mouseY, v);
    }
}

