/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.debugkeybind.gui;

import com.mojang.blaze3d.platform.InputConstants;
import dev.boxadactle.boxlib.gui.config.BOptionButton;
import dev.boxadactle.boxlib.gui.config.widget.button.BCustomButton;
import dev.boxadactle.boxlib.util.GuiUtils;
import dev.boxadactle.boxlib.util.RenderUtils;
import dev.boxadactle.debugkeybind.keybind.DebugKeybind;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class KeybindButton
extends BCustomButton {
    DebugKeybind keybind;
    Supplier<Boolean> onSelect;
    public boolean hasCollisions = false;

    public KeybindButton(DebugKeybind keybind, Supplier<Boolean> onSelect) {
        super(keybind.getKeyTranslation());
        this.keybind = keybind;
        this.onSelect = onSelect;
    }

    public void update(int keyPressed) {
        if (keyPressed != 256) {
            this.keybind.setKey(keyPressed);
        } else {
            this.keybind.setKey(InputConstants.UNKNOWN);
        }
        this.setMessage(this.keybind.getKeyTranslation());
    }

    public void resetKey() {
        this.keybind.setToDefault();
        this.setMessage(this.keybind.getKeyTranslation());
    }

    public void updateConflicts(List<Component> conflicts) {
        if (conflicts.isEmpty()) {
            this.setMessage(this.keybind.getKeyTranslation());
            this.setTooltip(null);
            this.hasCollisions = false;
            return;
        }
        this.setMessage(GuiUtils.colorize((Component)GuiUtils.surround((String)"[ ", (String)" ]", (Component)GuiUtils.colorize((Component)this.keybind.getKeyTranslation().copy().withStyle(ChatFormatting.UNDERLINE), (int)GuiUtils.WHITE)), (int)GuiUtils.RED));
        MutableComponent tooltip = Component.literal((String)"");
        for (int i = 0; i < conflicts.size(); ++i) {
            tooltip.append(conflicts.get(i));
            if (i == conflicts.size() - 1) continue;
            tooltip.append((Component)Component.literal((String)", "));
        }
        this.setTooltip(Tooltip.create((Component)Component.translatable((String)"controls.keybinds.duplicateKeybinds", (Object[])new Object[]{tooltip})));
        this.hasCollisions = true;
    }

    protected void buttonClicked(BOptionButton<?> button) {
        if (this.onSelect.get().booleanValue()) {
            this.setMessage(GuiUtils.colorize((Component)GuiUtils.surround((String)"> ", (String)" <", (Component)GuiUtils.colorize((Component)this.keybind.getKeyTranslation().copy().withStyle(ChatFormatting.UNDERLINE), (int)GuiUtils.WHITE)), (int)GuiUtils.YELLOW));
        }
    }

    public void renderWidget(GuiGraphics p_93657_, int mouseX, int mouseY, float delta) {
        super.renderWidget(p_93657_, mouseX, mouseY, delta);
        if (this.hasCollisions) {
            RenderUtils.drawSquare((GuiGraphics)p_93657_, (int)(this.getX() - 12), (int)this.getY(), (int)10, (int)this.height, (int)GuiUtils.RED);
        }
    }
}

