/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.debugkeybind.gui;

import dev.boxadactle.boxlib.gui.config.BOptionEntry;
import dev.boxadactle.boxlib.gui.config.BOptionScreen;
import dev.boxadactle.boxlib.gui.config.widget.button.BBooleanButton;
import dev.boxadactle.boxlib.gui.config.widget.label.BCenteredLabel;
import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.debugkeybind.DebugKeybindMain;
import dev.boxadactle.debugkeybind.gui.KeybindEntry;
import dev.boxadactle.debugkeybind.keybind.DebugKeybind;
import dev.boxadactle.debugkeybind.keybind.DebugKeybinds;
import dev.boxadactle.debugkeybind.keybind.KeybindConfig;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.controls.KeyBindsScreen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;

public class DebugKeybindsScreen
extends BOptionScreen {
    KeybindEntry selectedEntry;

    public DebugKeybindsScreen(Screen parent) {
        super(parent, (Component)Component.translatable((String)"controls.keybinds.debug.title"));
    }

    protected int getHeaderHeight() {
        return 33;
    }

    protected int getFooterHeight() {
        return 33;
    }

    protected int getRowWidth() {
        return 340;
    }

    protected int getScrollbarX() {
        return this.width - 15;
    }

    private void refreshEntries() {
        this.configList.children().forEach(entry -> {
            if (entry instanceof KeybindEntry) {
                ((KeybindEntry)((Object)entry)).refresh();
            }
        });
    }

    protected void initFooter(LinearLayout layout) {
        Button resetButton = (Button)layout.addChild((LayoutElement)this.createCancelButton(button -> {
            this.configList.children().forEach(entry -> {
                if (entry instanceof KeybindEntry) {
                    ((KeybindEntry)((Object)((Object)entry))).resetKey();
                }
            });
            this.refreshEntries();
        }));
        resetButton.setMessage((Component)Component.translatable((String)"controls.resetAll"));
        Button doneButton = (Button)layout.addChild((LayoutElement)this.createDoneButton(b -> {
            ClientUtils.setScreen((Screen)this.lastScreen);
            DebugKeybindMain.CONFIG.save();
        }));
        this.addRenderableWidget((GuiEventListener)resetButton);
        this.addRenderableWidget((GuiEventListener)doneButton);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"key.keys"), b -> ClientUtils.setScreen((Screen)new KeyBindsScreen(this.lastScreen, ClientUtils.getOptions()))).bounds(this.width - 77, 5, 75, 20).build());
    }

    protected void addOptions() {
        this.addConfigLine((BOptionEntry)new BCenteredLabel((Component)Component.translatable((String)"key.categories.debug")));
        for (DebugKeybind keybind : DebugKeybinds.getGlobalKeybinds()) {
            this.addConfigLine(new KeybindEntry(keybind, this::setSelectedEntry, this::refreshEntries));
        }
        this.addConfigLine((BOptionEntry)new BCenteredLabel((Component)Component.translatable((String)"key.categories.debug_actions")));
        this.addConfigLine((BOptionEntry)new BBooleanButton("button.requireDebugKey", Boolean.valueOf(((KeybindConfig)DebugKeybindMain.CONFIG.get()).requireDebugKey), value -> {
            ((KeybindConfig)DebugKeybindMain.CONFIG.get()).requireDebugKey = value;
            this.refreshEntries();
        }));
        for (DebugKeybind keybind : DebugKeybinds.getActionKeybinds()) {
            this.addConfigLine(new KeybindEntry(keybind, this::setSelectedEntry, this::refreshEntries));
        }
    }

    private boolean setSelectedEntry(KeybindEntry entry) {
        if (this.selectedEntry != null) {
            this.selectedEntry = null;
            return false;
        }
        this.selectedEntry = entry;
        return true;
    }

    public boolean keyPressed(KeyEvent event) {
        if (this.selectedEntry != null) {
            this.selectedEntry.updateKey(event.key());
            this.selectedEntry = null;
            return true;
        }
        return super.keyPressed(event);
    }

    public void onClose() {
        super.onClose();
        DebugKeybindMain.CONFIG.save();
    }
}

